/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.issue.comparator.ProjectNameComparator;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.ProjectFieldScreenHelper;
import com.atlassian.jira.issue.fields.screen.issuetype.ProjectIssueTypeScreenSchemeHelper;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.ProjectWorkflowSchemeHelper;
import com.atlassian.jira.workflow.WorkflowActionsBean;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProjectFieldScreenHelper
implements ProjectFieldScreenHelper {
    private static final Logger log = LoggerFactory.getLogger(DefaultProjectFieldScreenHelper.class);
    private final ProjectWorkflowSchemeHelper projectWorkflowSchemeHelper;
    private final ProjectIssueTypeScreenSchemeHelper issueTypeScreenSchemeHelper;
    private final WorkflowManager workflowManager;
    private final FieldScreenSchemeManager fieldScreenSchemeManager;
    private final PermissionManager permissionManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final FieldScreenManager fieldScreenManager;

    public DefaultProjectFieldScreenHelper(ProjectWorkflowSchemeHelper projectWorkflowSchemeHelper, ProjectIssueTypeScreenSchemeHelper issueTypeScreenSchemeHelper, WorkflowManager workflowManager, FieldScreenSchemeManager fieldScreenSchemeManager, PermissionManager permissionManager, GlobalPermissionManager globalPermissionManager, FieldScreenManager fieldScreenManager) {
        this.projectWorkflowSchemeHelper = projectWorkflowSchemeHelper;
        this.issueTypeScreenSchemeHelper = issueTypeScreenSchemeHelper;
        this.workflowManager = workflowManager;
        this.fieldScreenSchemeManager = fieldScreenSchemeManager;
        this.permissionManager = permissionManager;
        this.globalPermissionManager = globalPermissionManager;
        this.fieldScreenManager = fieldScreenManager;
    }

    @Override
    public List<Project> getProjectsForFieldScreen(FieldScreen fieldScreen) {
        TreeSet projects = Sets.newTreeSet((Comparator)ProjectNameComparator.COMPARATOR);
        Set<String> matchingWorkflows = this.findWorkflowsUsingScreen(fieldScreen);
        projects.addAll(this.projectWorkflowSchemeHelper.getProjectsForWorkflow(matchingWorkflows).values());
        HashSet fieldScreenSchemes = Sets.newHashSet((Iterable)this.fieldScreenSchemeManager.getFieldScreenSchemes(fieldScreen));
        projects.addAll(this.issueTypeScreenSchemeHelper.getProjectsForFieldScreenSchemes(fieldScreenSchemes).values());
        return Lists.newArrayList((Iterable)projects);
    }

    @Override
    public List<Project> getAllProjectsForFieldScreen(FieldScreen fieldScreen) {
        TreeSet projects = Sets.newTreeSet((Comparator)ProjectNameComparator.COMPARATOR);
        Set<String> matchingWorkflows = this.findWorkflowsUsingScreen(fieldScreen);
        projects.addAll(this.projectWorkflowSchemeHelper.getAllProjectsForWorkflow(matchingWorkflows).values());
        HashSet fieldScreenSchemes = Sets.newHashSet((Iterable)this.fieldScreenSchemeManager.getFieldScreenSchemes(fieldScreen));
        projects.addAll(this.issueTypeScreenSchemeHelper.getAllProjectsForFieldScreenSchemes(fieldScreenSchemes).values());
        return Lists.newArrayList((Iterable)projects);
    }

    @VisibleForTesting
    Set<String> findWorkflowsUsingScreen(FieldScreen fieldScreen) {
        HashSet matchingWorkflows = Sets.newHashSet();
        WorkflowActionsBean actionsBean = this.getActionsBean();
        Collection activeWorkflows = this.workflowManager.getActiveWorkflows();
        block0: for (JiraWorkflow activeWorkflow : activeWorkflows) {
            Collection allActions = activeWorkflow.getAllActions();
            for (ActionDescriptor actionDescriptor : allActions) {
                FieldScreen fieldScreenForView;
                Optional fieldScreenId = actionsBean.getFieldScreenIdForView(actionDescriptor);
                if (!fieldScreenId.isPresent() || (fieldScreenForView = this.fieldScreenManager.getFieldScreen((Long)fieldScreenId.get())) == null || !fieldScreenForView.equals(fieldScreen)) continue;
                matchingWorkflows.add(activeWorkflow.getName());
                continue block0;
            }
        }
        return matchingWorkflows;
    }

    @Override
    public boolean canUserViewFieldScreenForProject(ApplicationUser user, FieldScreen fieldScreen, Project project) {
        return this.permissionManager.hasPermission(0, user) || this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user) && this.isProjectUsingFieldScreen(fieldScreen, project);
    }

    @Override
    public boolean canUserEditScreen(ApplicationUser user, FieldScreen screen) {
        ProjectFieldScreenHelper.FieldsScreenPermission permission = this.getUserEditScreenPermission(user, screen);
        return permission == ProjectFieldScreenHelper.FieldsScreenPermission.EDITABLE || permission == ProjectFieldScreenHelper.FieldsScreenPermission.EDITABLE_DELEGATED;
    }

    @Override
    public ProjectFieldScreenHelper.FieldsScreenPermission getUserEditScreenPermission(ApplicationUser user, FieldScreen screen) {
        if (this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            log.debug("User {} has global admin permission to edit screen {}", (Object)user, (Object)screen);
            return ProjectFieldScreenHelper.FieldsScreenPermission.EDITABLE;
        }
        List<Project> projects = this.getAllProjectsForFieldScreen(screen);
        if (screen.getId().equals(FieldScreen.DEFAULT_SCREEN_ID)) {
            log.debug("User {} Padawan can not edit default screen {}", (Object)user, (Object)screen);
            return ProjectFieldScreenHelper.FieldsScreenPermission.READ_ONLY_DELEGATED_SYSTEM;
        }
        if (projects.size() != 1) {
            log.debug("User {} cannot edit screen {}. Screen usage count: {}", new Object[]{user, screen, projects.size()});
            return ProjectFieldScreenHelper.FieldsScreenPermission.READ_ONLY_DELEGATED_SHARED;
        }
        Project project = projects.get(0);
        if (ProjectAction.EDIT_PROJECT_CONFIG_EXTENDED.hasPermission(this.permissionManager, user, project)) {
            log.debug("User {} has EDIT_PROJECT_CONFIG_EXTENDED permission to edit screen {}", (Object)user, (Object)screen);
            return ProjectFieldScreenHelper.FieldsScreenPermission.EDITABLE_DELEGATED;
        }
        log.debug("User {} does not have EDIT_PROJECT_CONFIG_EXTENDED permission to edit screen {}", (Object)user, (Object)screen);
        return ProjectFieldScreenHelper.FieldsScreenPermission.NO_PERMISSION;
    }

    private boolean isProjectUsingFieldScreen(FieldScreen fieldScreen, Project project) {
        HashSet fieldScreenSchemes = Sets.newHashSet((Iterable)this.fieldScreenSchemeManager.getFieldScreenSchemes(fieldScreen));
        Collection projects = this.issueTypeScreenSchemeHelper.getProjectsForFieldScreenSchemes(fieldScreenSchemes).values();
        return projects.contains(project);
    }

    @VisibleForTesting
    WorkflowActionsBean getActionsBean() {
        return new WorkflowActionsBean();
    }
}

