/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest;

import com.atlassian.jira.issue.fields.rest.IssueLinkTypeFinder;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinkTypeJsonBean;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public final class IssueLinkTypeFinderImpl
implements IssueLinkTypeFinder {
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public IssueLinkTypeFinderImpl(IssueLinkTypeManager issueLinkTypeManager, I18nHelper.BeanFactory i18nFactory, JiraAuthenticationContext jiraAuthenticationContext) {
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.i18nFactory = i18nFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public IssueLinkType findIssueLinkType(IssueLinkTypeJsonBean linkTypeBean, ErrorCollection errors) {
        if (StringUtils.isNotBlank((CharSequence)linkTypeBean.id())) {
            IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(Long.valueOf(Long.parseLong(linkTypeBean.id())));
            if (issueLinkType == null) {
                errors.addErrorMessage(this.getText("rest.issue.link.type.with.id.not.found", linkTypeBean.id()));
            }
            return issueLinkType;
        }
        if (StringUtils.isNotBlank((CharSequence)linkTypeBean.name())) {
            Collection linkTypes = this.issueLinkTypeManager.getIssueLinkTypesByName(linkTypeBean.name());
            if (linkTypes == null || linkTypes.isEmpty()) {
                errors.addErrorMessage(this.getText("rest.issue.link.type.not.found", linkTypeBean.name()));
                return null;
            }
            if (linkTypes.size() > 1) {
                errors.addErrorMessage(this.getText("rest.issue.link.type.ambiguous.name", linkTypeBean.name()));
                return null;
            }
            return (IssueLinkType)linkTypes.iterator().next();
        }
        errors.addError("issuelinks", this.getText("rest.issue.link.type.no.id.or.name", new String[0]));
        return null;
    }

    private String getText(String key, String ... params) {
        return this.i18nFactory.getInstance(this.jiraAuthenticationContext.getUser()).getText(key, (Object)params);
    }
}

