/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.fields.rest.FieldOperationHolder;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractFieldOperationsHandler<T>
implements RestFieldOperationsHandler {
    protected final I18nHelper i18nHelper;

    public AbstractFieldOperationsHandler(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }

    protected abstract T getInitialValue(Issue var1, ErrorCollection var2);

    protected abstract T getInitialCreateValue();

    protected abstract void finaliseOperation(T var1, IssueInputParameters var2, ErrorCollection var3);

    public ErrorCollection updateIssueInputParameters(IssueContext issueCtx, Issue issue, String fieldId, IssueInputParameters inputParameters, List<FieldOperationHolder> operations) {
        T newFieldValue;
        SimpleErrorCollection errors = new SimpleErrorCollection();
        T t = newFieldValue = issue == null ? this.getInitialCreateValue() : this.getInitialValue(issue, (ErrorCollection)errors);
        if (errors.hasAnyErrors()) {
            return errors;
        }
        for (FieldOperationHolder operation : operations) {
            String oper = operation.getOperation();
            JsonData operationValue = operation.getData();
            try {
                StandardOperation standardOperation = StandardOperation.valueOf((String)oper.toUpperCase());
                switch (standardOperation) {
                    case ADD: {
                        newFieldValue = this.handleAddOperation(issueCtx, issue, fieldId, newFieldValue, operationValue, (ErrorCollection)errors);
                        break;
                    }
                    case SET: {
                        newFieldValue = this.handleSetOperation(issueCtx, issue, fieldId, newFieldValue, operationValue, (ErrorCollection)errors);
                        break;
                    }
                    case REMOVE: {
                        newFieldValue = this.handleRemoveOperation(issueCtx, issue, fieldId, newFieldValue, operationValue, (ErrorCollection)errors);
                        break;
                    }
                    default: {
                        newFieldValue = this.applyOperation(issueCtx, issue, fieldId, standardOperation, newFieldValue, operationValue, (ErrorCollection)errors);
                        break;
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                errors.addErrorMessage(this.i18nHelper.getText("rest.operation.invalid", oper, StringUtils.join((Object[])StandardOperation.values(), (String)",")));
            }
        }
        if (errors.hasAnyErrors()) {
            return errors;
        }
        this.finaliseOperation(newFieldValue, inputParameters, (ErrorCollection)errors);
        return errors;
    }

    protected T applyOperation(IssueContext issueCtx, Issue issue, String fieldId, StandardOperation operation, T currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        throw new UnsupportedOperationException(this.i18nHelper.getText("rest.operation.not.supported", operation.getName()));
    }

    protected T handleRemoveOperation(IssueContext issueCtx, Issue issue, String fieldId, T currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        throw new UnsupportedOperationException(this.i18nHelper.getText("rest.operation.not.supported", "Remove"));
    }

    protected T handleSetOperation(IssueContext issueCtx, Issue issue, String fieldId, T currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        throw new UnsupportedOperationException(this.i18nHelper.getText("rest.operation.not.supported", "Set"));
    }

    protected T handleAddOperation(IssueContext issueCtx, Issue issue, String fieldId, T currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        throw new UnsupportedOperationException(this.i18nHelper.getText("rest.operation.not.supported", "Add"));
    }

    protected Long[] toLongIds(Collection<String> ids, String fieldName, ErrorCollection errors) {
        ArrayList<Long> result = new ArrayList<Long>(ids.size());
        for (String id : ids) {
            try {
                result.add(Long.parseLong(id));
            }
            catch (NumberFormatException e) {
                errors.addError(fieldName, this.i18nHelper.getText("rest.could.not.parse.id", id), ErrorCollection.Reason.VALIDATION_FAILED);
                return null;
            }
        }
        return result.toArray(new Long[result.size()]);
    }
}

