/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki.links;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.JiraPluginTransactionEndEvent;
import com.atlassian.jira.plugin.contentlinkresolver.ContentLinkResolverDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorComparator;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.ContentLinkResolver;
import com.atlassian.renderer.links.GenericLinkParser;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.LinkResolver;
import com.atlassian.renderer.links.UnresolvedLink;
import com.atlassian.renderer.links.UrlLink;
import com.atlassian.renderer.util.UrlUtil;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraLinkResolver
implements LinkResolver {
    private static final Logger log = LoggerFactory.getLogger(JiraLinkResolver.class);
    private final LinkResolverProvider linkResolverProvider;

    public JiraLinkResolver(PluginAccessor pluginAccessor, EventPublisher eventPublisher) {
        this.linkResolverProvider = new LinkResolverProvider(pluginAccessor);
        eventPublisher.register((Object)this.linkResolverProvider);
    }

    public Link createLink(RenderContext context, String linkText) {
        try {
            GenericLinkParser parser = new GenericLinkParser(linkText);
            if (TextUtils.stringSet((String)parser.getNotLinkBody())) {
                if (UrlUtil.startsWithUrl((String)parser.getNotLinkBody()) || parser.getNotLinkBody().startsWith("//") || parser.getNotLinkBody().startsWith("\\\\")) {
                    return new UrlLink(parser);
                }
                parser.parseAsContentLink();
                for (ContentLinkResolver resolver : this.linkResolverProvider.getLinkResolvers()) {
                    Link link = resolver.createContentLink(context, parser);
                    if (link == null) continue;
                    return link;
                }
            }
        }
        catch (Exception e) {
            Issue issue = (Issue)context.getParam((Object)"jira.issue");
            log.debug("Unable to create a link for issue: {}", (Object)(issue == null ? "null" : issue.getKey()));
        }
        return new UnresolvedLink(linkText);
    }

    public List extractLinks(RenderContext context, String links) {
        return null;
    }

    public List extractLinkTextList(String pageContent) {
        return null;
    }

    public String removeLinkBrackets(String linkText) {
        if (TextUtils.stringSet((String)linkText) && linkText.startsWith("[") && linkText.endsWith("]")) {
            return linkText.substring(1, linkText.length() - 1);
        }
        return linkText;
    }

    LinkResolverProvider getLinkResolverProvider() {
        return this.linkResolverProvider;
    }

    public static class LinkResolverProvider {
        private final PluginAccessor accessor;
        private final ResettableLazyReference<List<ContentLinkResolver>> linkResolvers = new ResettableLazyReference<List<ContentLinkResolver>>(){

            protected List<ContentLinkResolver> create() throws Exception {
                ArrayList descriptors = Lists.newArrayList((Iterable)accessor.getEnabledModuleDescriptorsByClass(ContentLinkResolverDescriptor.class));
                Collections.sort(descriptors, ModuleDescriptorComparator.COMPARATOR);
                return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)descriptors, (Function)new Function<ContentLinkResolverDescriptor, ContentLinkResolver>(){

                    public ContentLinkResolver apply(ContentLinkResolverDescriptor from) {
                        return (ContentLinkResolver)from.getModule();
                    }
                }));
            }
        };

        private LinkResolverProvider(PluginAccessor accessor) {
            this.accessor = accessor;
        }

        List<ContentLinkResolver> getLinkResolvers() {
            return (List)this.linkResolvers.get();
        }

        @EventListener
        public void onJiraPluginTransactionEndEvent(JiraPluginTransactionEndEvent event) {
            if (event.hasAnyEventWithModuleDescriptorMatching(ContentLinkResolverDescriptor.class::isInstance)) {
                this.linkResolvers.reset();
            }
        }
    }
}

