/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki.embedded;

import com.atlassian.jira.issue.fields.renderer.wiki.embedded.ConditionalEmbeddedRenderer;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.attachments.RendererAttachment;
import com.atlassian.renderer.attachments.RendererAttachmentManager;
import com.atlassian.renderer.embedded.EmbeddedImage;
import com.atlassian.renderer.embedded.EmbeddedResource;
import com.atlassian.renderer.embedded.PlaceholderImageRenderer;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraPlaceholderImageRenderer
extends PlaceholderImageRenderer
implements ConditionalEmbeddedRenderer {
    private static final Logger log = LoggerFactory.getLogger(JiraPlaceholderImageRenderer.class);
    private final RendererAttachmentManager attachmentManager;

    public JiraPlaceholderImageRenderer(RendererAttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public String renderResource(EmbeddedResource resource, RenderContext context) {
        if (Objects.isNull(context.getParam((Object)"com.atlassian.renderer.embedded.placeholder.image.name"))) {
            context.addParam((Object)"com.atlassian.renderer.embedded.placeholder.image.name", (Object)"/icons/attach/noimage.png");
        }
        return super.renderResource(resource, context);
    }

    @Override
    public boolean shouldRenderResource(EmbeddedResource resource, RenderContext context) {
        if (!(resource instanceof EmbeddedImage)) {
            return false;
        }
        if (resource.isInternal()) {
            RendererAttachment attachment = null;
            try {
                attachment = this.attachmentManager.getAttachment(context, resource);
            }
            catch (Exception e) {
                log.warn("Unable to obtain attachment " + e.getMessage());
            }
            if (attachment == null) {
                return true;
            }
        }
        return false;
    }
}

