/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.fields.renderer.JiraRendererPlugin;
import com.atlassian.jira.issue.fields.renderer.wiki.WikiRendererFactory;
import com.atlassian.jira.plugin.renderer.JiraRendererModuleDescriptor;
import com.atlassian.jira.util.BrowserUtils;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.V2RendererFacade;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.DisposableBean;

public class AtlassianWikiRenderer
implements JiraRendererPlugin,
DisposableBean {
    public static final String ISSUE_CONTEXT_KEY = "jira.issue";
    public static final String RENDERER_TYPE = "atlassian-wiki-renderer";
    private volatile JiraRendererModuleDescriptor jiraRendererModuleDescriptor;
    private final WikiRendererFactory wikiFactory = new WikiRendererFactory();
    private final EventPublisher eventPublisher;
    private final ApplicationProperties applicationProperties;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final FeatureManager featureManager;

    public AtlassianWikiRenderer(EventPublisher eventPublisher, ApplicationProperties applicationProperties, VelocityRequestContextFactory velocityRequestContextFactory, FeatureManager featureManager) {
        this.eventPublisher = eventPublisher;
        this.applicationProperties = applicationProperties;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.featureManager = featureManager;
        this.eventPublisher.register((Object)this.wikiFactory);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this.wikiFactory);
    }

    public String render(String value, IssueRenderContext context) {
        return this.getRendererFacade().convertWikiToXHtml(this.getRenderContext(context), value);
    }

    public String renderAsText(String value, IssueRenderContext context) {
        return this.getRendererFacade().convertWikiToText(this.getRenderContext(context), value);
    }

    public String getRendererType() {
        return RENDERER_TYPE;
    }

    public Object transformForEdit(Object rawValue) {
        return rawValue;
    }

    public Object transformFromEdit(Object editValue) {
        return editValue;
    }

    public void init(JiraRendererModuleDescriptor jiraRendererModuleDescriptor) {
        this.jiraRendererModuleDescriptor = jiraRendererModuleDescriptor;
    }

    public JiraRendererModuleDescriptor getDescriptor() {
        return this.jiraRendererModuleDescriptor;
    }

    private V2RendererFacade getRendererFacade() {
        return this.getWikiRendererFactory().getWikiRenderer();
    }

    @Nonnull
    RenderContext getRenderContext(@Nullable IssueRenderContext context) {
        RenderContext renderContext = new RenderContext();
        if (context != null) {
            renderContext.getParams().putAll(context.getParams());
            if (context.getIssue() != null) {
                renderContext.addParam((Object)ISSUE_CONTEXT_KEY, (Object)context.getIssue());
            }
        }
        renderContext.setBaseUrl(this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl());
        renderContext.pushRenderMode(this.buildConfiguredRenderMode(context));
        renderContext.addParam((Object)"com.atlassian.renderer.v2.components.macro.render.consider.variable.format", (Object)this.featureManager.isEnabled(JiraFeatureFlagRegistrar.RENDERER_CONSIDER_VARIABLE_FORMAT_FEATURE));
        return renderContext;
    }

    @Nonnull
    private RenderMode buildConfiguredRenderMode(@Nullable IssueRenderContext context) {
        return this.suppressParagraphsIfNeeded(context, this.getRenderModeBasedOnMimeSniffingPolicy());
    }

    @Nonnull
    private RenderMode suppressParagraphsIfNeeded(@Nullable IssueRenderContext context, @Nonnull RenderMode renderMode) {
        if (context != null && context.getParam((Object)"atlassian-renderer-inline-param") == Boolean.TRUE) {
            return renderMode.and(RenderMode.suppress((long)1L));
        }
        return renderMode;
    }

    @Nonnull
    private RenderMode getRenderModeBasedOnMimeSniffingPolicy() {
        String mimeSniffingPolicy = this.applicationProperties.getDefaultBackedString("jira.attachment.download.mime.sniffing.workaround");
        if (mimeSniffingPolicy.equalsIgnoreCase("insecure")) {
            return RenderMode.suppress((long)16384L);
        }
        if (mimeSniffingPolicy.equalsIgnoreCase("secure")) {
            return RenderMode.suppress((long)49184L);
        }
        if (mimeSniffingPolicy.equalsIgnoreCase("workaround")) {
            HttpServletRequest request = this.getCurrentRequest();
            if (request != null) {
                return this.getRenderModeForWorkaroundSniffingPolicyBasedOnUserBrowser(request);
            }
            return RenderMode.suppress((long)49152L);
        }
        return RenderMode.ALL;
    }

    @Nonnull
    private RenderMode getRenderModeForWorkaroundSniffingPolicyBasedOnUserBrowser(@Nonnull HttpServletRequest request) {
        if (BrowserUtils.isIe456Or7((String)request.getHeader("USER-AGENT"))) {
            return RenderMode.suppress((long)49152L);
        }
        return RenderMode.suppress((long)16384L);
    }

    @VisibleForTesting
    protected HttpServletRequest getCurrentRequest() {
        return ExecutingHttpRequest.get();
    }

    private WikiRendererFactory getWikiRendererFactory() {
        return this.wikiFactory;
    }
}

