/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.option;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryCallback;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.option.IssueConstantOptionSet;
import com.atlassian.jira.issue.fields.option.OptionSet;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.model.querydsl.QFieldConfiguration;
import com.atlassian.jira.model.querydsl.QOptionConfiguration;
import com.atlassian.jira.util.log.RateLimitingLogger;
import com.google.common.annotations.VisibleForTesting;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class OptionSetManagerImpl
implements OptionSetManager {
    private static final RateLimitingLogger LOG = new RateLimitingLogger(OptionSetManagerImpl.class);
    private final ConstantsManager constantsManager;
    private final QueryDslAccessor queryDslAccessor;

    public OptionSetManagerImpl(ConstantsManager constantsManager, QueryDslAccessor queryDslAccessor) {
        this.constantsManager = constantsManager;
        this.queryDslAccessor = queryDslAccessor;
    }

    @Nonnull
    public OptionSet getOptionsForConfig(FieldConfig config) {
        OptionSetManagerImpl.validateParametersAreNonNull(config);
        return this.getOptionsForConfig(config.getFieldId(), config.getId());
    }

    @Nonnull
    public OptionSet getOptionsForConfig(@Nonnull String fieldId, @Nonnull Long configId) {
        return this.queryDslAccessor.executeQuery(db -> this.getOptionsForConfig(db, fieldId, configId));
    }

    private OptionSet getOptionsForConfig(DbConnection db, String fieldId, Long configId) {
        List<String> optionIds = OptionSetManagerImpl.getOptionIds(db, fieldId, configId);
        List<IssueConstant> constants = this.toIssueConstants(fieldId, optionIds);
        return new IssueConstantOptionSet(this.constantsManager, constants);
    }

    private static List<String> getOptionIds(DbConnection db, String fieldId, Long configId) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.newSqlQuery().select((Expression)QOptionConfiguration.OPTION_CONFIGURATION.optionid).from((Expression)QOptionConfiguration.OPTION_CONFIGURATION)).where((Predicate)QOptionConfiguration.OPTION_CONFIGURATION.fieldid.eq((Object)fieldId))).where((Predicate)QOptionConfiguration.OPTION_CONFIGURATION.fieldconfig.eq((Object)configId))).orderBy(QOptionConfiguration.OPTION_CONFIGURATION.sequence.asc())).fetch();
    }

    private List<IssueConstant> toIssueConstants(String fieldId, List<String> optionIds) {
        return (List)optionIds.stream().map(optionId -> this.constantsManager.getConstantObject(fieldId, optionId)).filter(Objects::nonNull).collect(CollectorsUtil.toNewArrayListWithSizeOf(optionIds));
    }

    @Nonnull
    public OptionSet createOptionSet(FieldConfig config, Collection<String> optionIds) {
        return this.createOrReplaceOptionSet(config, optionIds);
    }

    @Nonnull
    public OptionSet updateOptionSet(FieldConfig config, Collection<String> optionIds) {
        return this.createOrReplaceOptionSet(config, optionIds);
    }

    @Nonnull
    public OptionSet addOptionToOptionSet(FieldConfig config, String optionId) {
        OptionSetManagerImpl.validateParametersAreNonNull(config);
        String fieldId = config.getFieldId();
        Long configId = config.getId();
        return this.runWithFieldConfigurationLocked(config, db -> {
            this.appendSingleOptionToOptionSet(db, fieldId, configId, optionId);
            return this.getOptionsForConfig(db, fieldId, configId);
        });
    }

    @Nonnull
    public OptionSet removeOptionFromOptionSet(FieldConfig config, String optionId) {
        OptionSetManagerImpl.validateParametersAreNonNull(config);
        String fieldId = config.getFieldId();
        Long configId = config.getId();
        return this.runWithFieldConfigurationLocked(config, db -> {
            this.deleteSingleOption(db, fieldId, configId, optionId);
            return this.getOptionsForConfig(db, fieldId, configId);
        });
    }

    private OptionSet createOrReplaceOptionSet(FieldConfig config, Collection<String> optionIds) {
        OptionSetManagerImpl.validateParametersAreNonNull(config);
        String fieldId = config.getFieldId();
        Long configId = config.getId();
        return this.queryDslAccessor.executeQuery(db -> {
            this.deleteAllOptionsFromOptionSet(db, fieldId, configId);
            this.storeAllOptions(db, fieldId, configId, optionIds);
            return this.getOptionsForConfig(db, fieldId, configId);
        });
    }

    private void storeAllOptions(DbConnection db, String fieldId, Long fieldConfigId, @Nullable Collection<String> optionIds) {
        if (optionIds == null) {
            LOG.warnWithTrace("Please use removeOptionSet instead of passing in a null collection of optionIds");
            return;
        }
        long seq = 0L;
        for (String optionId : optionIds) {
            db.insert(QOptionConfiguration.OPTION_CONFIGURATION).set((Path)QOptionConfiguration.OPTION_CONFIGURATION.fieldconfig, fieldConfigId).set((Path)QOptionConfiguration.OPTION_CONFIGURATION.fieldid, fieldId).set((Path)QOptionConfiguration.OPTION_CONFIGURATION.sequence, (Object)seq).set((Path)QOptionConfiguration.OPTION_CONFIGURATION.optionid, optionId).executeWithId();
            ++seq;
        }
    }

    private void appendSingleOptionToOptionSet(DbConnection db, String fieldId, Long fieldConfigId, String optionId) {
        Long seq = OptionSetManagerImpl.getNextSequenceNumber(db, fieldId, fieldConfigId);
        this.insertSingleOption(db, fieldId, fieldConfigId, optionId, seq);
    }

    private static Long getNextSequenceNumber(DbConnection db, String fieldId, Long fieldConfigId) {
        Long seq = (Long)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.newSqlQuery().select(QOptionConfiguration.OPTION_CONFIGURATION.sequence).from((Expression)QOptionConfiguration.OPTION_CONFIGURATION)).where((Predicate)QOptionConfiguration.OPTION_CONFIGURATION.fieldid.eq((Object)fieldId))).where((Predicate)QOptionConfiguration.OPTION_CONFIGURATION.fieldconfig.eq((Object)fieldConfigId))).orderBy(QOptionConfiguration.OPTION_CONFIGURATION.sequence.desc())).fetchFirst();
        if (seq == null) {
            return 0L;
        }
        return seq + 1L;
    }

    @VisibleForTesting
    void insertSingleOption(DbConnection db, String fieldId, Long fieldConfigId, String optionId, Long sequence) {
        db.insert(QOptionConfiguration.OPTION_CONFIGURATION).set((Path)QOptionConfiguration.OPTION_CONFIGURATION.fieldconfig, fieldConfigId).set((Path)QOptionConfiguration.OPTION_CONFIGURATION.fieldid, fieldId).set((Path)QOptionConfiguration.OPTION_CONFIGURATION.sequence, sequence).set((Path)QOptionConfiguration.OPTION_CONFIGURATION.optionid, optionId).executeWithId();
    }

    private void deleteSingleOption(DbConnection db, String fieldId, Long fieldConfigId, String optionId) {
        db.delete((RelationalPath<?>)QOptionConfiguration.OPTION_CONFIGURATION).where((Predicate)QOptionConfiguration.OPTION_CONFIGURATION.fieldid.eq((Object)fieldId)).where((Predicate)QOptionConfiguration.OPTION_CONFIGURATION.fieldconfig.eq((Object)fieldConfigId)).where((Predicate)QOptionConfiguration.OPTION_CONFIGURATION.optionid.eq((Object)optionId)).execute();
    }

    public void removeOptionSet(FieldConfig config) {
        OptionSetManagerImpl.validateParametersAreNonNull(config);
        this.queryDslAccessor.execute(db -> this.deleteAllOptionsFromOptionSet(db, config.getFieldId(), config.getId()));
    }

    private void deleteAllOptionsFromOptionSet(DbConnection db, String fieldId, Long fieldConfigId) {
        db.delete((RelationalPath<?>)QOptionConfiguration.OPTION_CONFIGURATION).where((Predicate)QOptionConfiguration.OPTION_CONFIGURATION.fieldid.eq((Object)fieldId)).where((Predicate)QOptionConfiguration.OPTION_CONFIGURATION.fieldconfig.eq((Object)fieldConfigId)).execute();
    }

    private <T> T runWithFieldConfigurationLocked(FieldConfig fieldConfig, QueryCallback<T> callback) {
        return (T)this.queryDslAccessor.withNewConnection().executeQuery(db -> {
            db.setAutoCommit(false);
            this.lockFieldConfigurationForEditing(db, fieldConfig.getId());
            Object result = callback.runQuery(db);
            db.commit();
            return result;
        });
    }

    private void lockFieldConfigurationForEditing(DbConnection db, Long fieldConfigId) {
        List fieldsLocked = ((SQLQuery)((SQLQuery)((SQLQuery)db.newSqlQuery().select(QFieldConfiguration.FIELD_CONFIGURATION.id).from((Expression)QFieldConfiguration.FIELD_CONFIGURATION)).where((Predicate)QFieldConfiguration.FIELD_CONFIGURATION.id.eq((Object)fieldConfigId))).forUpdate()).fetch();
        if (fieldsLocked.isEmpty()) {
            throw new IllegalStateException("Trying to update option set sequences for non-existent field config id=" + fieldConfigId);
        }
    }

    private static void validateParametersAreNonNull(FieldConfig config) {
        Objects.requireNonNull(config, "config");
        Objects.requireNonNull(config.getFieldId(), "config.fieldId");
        Objects.requireNonNull(config.getId(), "config.id");
    }
}

