/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.option;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.issue.fields.option.OptionSet;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.fields.option.OptionSetManagerImpl;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@EventComponent
@ParametersAreNonnullByDefault
public class CachedOptionSetManager
implements OptionSetManager {
    private final OptionSetManager delegate;
    private final Cache<Long, OptionSet> cache;

    public CachedOptionSetManager(OptionSetManagerImpl delegate, CacheManager cacheManager) {
        this.delegate = delegate;
        this.cache = cacheManager.getCache(CachedOptionSetManager.class.getName() + ".cache", this::loadOptionsForConfig);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.removeAll();
    }

    @Nonnull
    public OptionSet getOptionsForConfig(FieldConfig config) {
        Objects.requireNonNull(config, "config");
        return (OptionSet)this.cache.get((Object)config.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public OptionSet createOptionSet(FieldConfig config, Collection<String> optionIds) {
        Objects.requireNonNull(config, "config");
        try {
            OptionSet optionSet = this.delegate.updateOptionSet(config, optionIds);
            return optionSet;
        }
        finally {
            this.cache.remove((Object)config.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public OptionSet updateOptionSet(FieldConfig config, Collection<String> optionIds) {
        Objects.requireNonNull(config, "config");
        try {
            OptionSet optionSet = this.delegate.updateOptionSet(config, optionIds);
            return optionSet;
        }
        finally {
            this.cache.remove((Object)config.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionSet addOptionToOptionSet(FieldConfig config, String optionId) {
        Objects.requireNonNull(config, "config");
        Objects.requireNonNull(optionId, "optionId");
        try {
            OptionSet optionSet = this.delegate.addOptionToOptionSet(config, optionId);
            return optionSet;
        }
        finally {
            this.cache.remove((Object)config.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionSet removeOptionFromOptionSet(FieldConfig config, String optionId) {
        Objects.requireNonNull(config, "config");
        Objects.requireNonNull(optionId, "optionId");
        try {
            OptionSet optionSet = this.delegate.removeOptionFromOptionSet(config, optionId);
            return optionSet;
        }
        finally {
            this.cache.remove((Object)config.getId());
        }
    }

    public void removeOptionSet(FieldConfig config) {
        Objects.requireNonNull(config, "config");
        try {
            this.delegate.removeOptionSet(config);
        }
        finally {
            this.cache.remove((Object)config.getId());
        }
    }

    @Nonnull
    private OptionSet loadOptionsForConfig(Long fieldConfigId) {
        FieldConfigManager fieldConfigManager = (FieldConfigManager)ComponentAccessor.getComponent(FieldConfigManager.class);
        return this.delegate.getOptionsForConfig(fieldConfigManager.getFieldConfig(fieldConfigId));
    }
}

