/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config.manager;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.issue.field.config.manager.PrioritySchemeCreatedEvent;
import com.atlassian.jira.event.issue.field.config.manager.PrioritySchemeDeletedEvent;
import com.atlassian.jira.event.issue.field.config.manager.PrioritySchemeUpdatedEvent;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.ProjectContext;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class PrioritySchemeManagerImpl
implements PrioritySchemeManager {
    private final ComponentReference<FieldManager> fieldManagerRef;
    private final ComponentReference<ApplicationProperties> applicationPropertiesRef = ComponentAccessor.getComponentReference(ApplicationProperties.class);
    private final FeatureManager featureManager;
    private final ConstantsManager constantsManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final OptionSetManager optionSetManager;
    private final GenericConfigManager genericConfigManager;
    private final EventPublisher eventPublisher;
    private final ProjectManager projectManager;
    private static final Comparator<FieldConfigScheme> BY_NAME_NULLS_FIRST = Comparator.comparing(FieldConfigScheme::getName, Comparator.nullsFirst(String::compareToIgnoreCase));

    public PrioritySchemeManagerImpl(FieldConfigSchemeManager fieldConfigSchemeManager, OptionSetManager optionSetManager, GenericConfigManager genericConfigManager, ConstantsManager constantsManager, EventPublisher eventPublisher, FeatureManager featureManager, ProjectManager projectManager) {
        this.fieldManagerRef = ComponentAccessor.getComponentReference(FieldManager.class);
        this.featureManager = featureManager;
        this.constantsManager = constantsManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.optionSetManager = optionSetManager;
        this.genericConfigManager = genericConfigManager;
        this.eventPublisher = eventPublisher;
        this.projectManager = projectManager;
    }

    public FieldConfigScheme getScheme(Project project) {
        return this.fieldConfigSchemeManager.getRelevantConfigScheme(project, this.getField());
    }

    public FieldConfigScheme getScheme(Long id) {
        Assertions.notNull((String)"id", (Object)id);
        return this.fieldConfigSchemeManager.getFieldConfigScheme(id);
    }

    public FieldConfigScheme getDefaultScheme() {
        Long schemeId = this.getDefaultSchemeId();
        return this.fieldConfigSchemeManager.getFieldConfigScheme(schemeId);
    }

    public List<FieldConfigScheme> getAllSchemes() {
        ArrayList<FieldConfigScheme> schemes = new ArrayList<FieldConfigScheme>(this.fieldConfigSchemeManager.getConfigSchemesForField(this.getField()));
        Collections.sort(schemes, this.schemeComparator());
        return schemes;
    }

    public boolean isDefaultScheme(FieldConfigScheme fieldConfigScheme) {
        Assertions.notNull((String)"fieldConfigScheme", (Object)fieldConfigScheme);
        Long id = fieldConfigScheme.getId();
        return id != null && id.equals(this.getDefaultSchemeId());
    }

    public String getDefaultOption(IssueContext issueContext) {
        Assertions.notNull((String)"issueContext", (Object)issueContext);
        if (!this.isPrioritiesPerProjectEnabled()) {
            return Optional.ofNullable(this.constantsManager.getDefaultPriority()).map(IssueConstant::getId).orElse(null);
        }
        FieldConfig config = this.fieldConfigSchemeManager.getRelevantConfig(issueContext, this.getField());
        return this.getDefaultPriorityOrMiddleOne(config);
    }

    public String getDefaultOption(FieldConfig fieldConfig) {
        if (fieldConfig != null) {
            return (String)this.genericConfigManager.retrieve("DefaultValue", fieldConfig.getId().toString());
        }
        return null;
    }

    public void setDefaultOption(FieldConfig fieldConfig, String optionId) {
        Assertions.notNull((String)"fieldConfig", (Object)fieldConfig);
        this.genericConfigManager.update("DefaultValue", fieldConfig.getId().toString(), (Object)optionId);
        this.getFieldManager().refresh();
    }

    public List<String> getOptions(IssueContext issueContext) {
        if (!this.isPrioritiesPerProjectEnabled()) {
            return this.getGlobalPriorityIds();
        }
        if (Objects.isNull(issueContext)) {
            return this.getOptions(this.getFieldConfigForDefaultMapping(this.getDefaultScheme()));
        }
        return this.getOptions(this.fieldConfigSchemeManager.getRelevantConfig(issueContext, this.getField()));
    }

    private List<String> getGlobalPriorityIds() {
        return this.constantsManager.getPriorities().stream().map(IssueConstant::getId).collect(Collectors.toList());
    }

    public List<String> getOptions(FieldConfig fieldConfig) {
        if (!this.isPrioritiesPerProjectEnabled()) {
            return this.getGlobalPriorityIds();
        }
        if (Objects.isNull(fieldConfig)) {
            return ImmutableList.of();
        }
        return this.optionSetManager.getOptionsForConfig(fieldConfig).getOptions().stream().map(Option::getId).collect(Collectors.toList());
    }

    public void setOptions(FieldConfig fieldConfig, List<String> optionIds) {
        Assertions.notNull((String)"fieldConfig", (Object)fieldConfig);
        this.optionSetManager.updateOptionSet(fieldConfig, optionIds);
    }

    public FieldConfigScheme createWithDefaultMapping(@Nonnull String name, String description, List<String> optionIds) {
        Assertions.notNull((String)"name", (Object)name);
        FieldConfigScheme configScheme = new FieldConfigScheme.Builder().setName(name).setDescription(description).toFieldConfigScheme();
        configScheme = this.fieldConfigSchemeManager.createFieldConfigScheme(configScheme, null, FieldConfigSchemeManager.ALL_ISSUE_TYPES, this.getField());
        FieldConfig config = this.getFieldConfigForDefaultMapping(configScheme);
        this.setOptions(config, optionIds);
        this.getFieldManager().refresh();
        this.eventPublisher.publish((Object)new PrioritySchemeCreatedEvent(configScheme));
        return configScheme;
    }

    public FieldConfigScheme updateWithDefaultMapping(FieldConfigScheme fieldConfigScheme, List<String> optionIds) {
        Assertions.notNull((String)"fieldConfigScheme", (Object)fieldConfigScheme);
        fieldConfigScheme = this.fieldConfigSchemeManager.updateFieldConfigScheme(fieldConfigScheme);
        FieldConfig config = this.getFieldConfigForDefaultMapping(fieldConfigScheme);
        this.optionSetManager.updateOptionSet(config, optionIds);
        this.triggerSchemeUpdated(fieldConfigScheme);
        return fieldConfigScheme;
    }

    public FieldConfig getFieldConfigForDefaultMapping(FieldConfigScheme fieldConfigScheme) {
        return Optional.ofNullable(fieldConfigScheme).map(FieldConfigScheme::getOneAndOnlyConfig).orElse(null);
    }

    public void delete(FieldConfigScheme fieldConfigScheme) {
        Assertions.notNull((String)"fieldConfigScheme", (Object)fieldConfigScheme);
        boolean defaultFieldConfigScheme = this.isDefaultScheme(fieldConfigScheme);
        this.fieldConfigSchemeManager.removeFieldConfigScheme(fieldConfigScheme.getId());
        if (defaultFieldConfigScheme) {
            ((ApplicationProperties)this.applicationPropertiesRef.get()).setString("jira.scheme.default.priority", null);
        }
        this.getFieldManager().refresh();
        this.eventPublisher.publish((Object)new PrioritySchemeDeletedEvent(fieldConfigScheme));
    }

    public void addOptionToDefault(String optionId) {
        Assertions.notNull((String)"optionId", (Object)optionId);
        if (!this.isPrioritiesPerProjectEnabled()) {
            return;
        }
        FieldConfigScheme defaultPriorityScheme = this.getDefaultScheme();
        if (Objects.isNull(defaultPriorityScheme)) {
            return;
        }
        this.optionSetManager.addOptionToOptionSet(this.getFieldConfigForDefaultMapping(defaultPriorityScheme), optionId);
        this.triggerSchemeUpdated(defaultPriorityScheme);
    }

    public void removeOptionFromAllSchemes(String optionId) {
        Assertions.notNull((String)"optionIn", (Object)optionId);
        Collection<FieldConfigScheme> relatedSchemes = this.getAllRelatedSchemes(optionId);
        for (FieldConfigScheme configScheme : relatedSchemes) {
            this.optionSetManager.removeOptionFromOptionSet(this.getFieldConfigForDefaultMapping(configScheme), optionId);
            this.triggerSchemeUpdated(configScheme);
        }
    }

    public Collection<FieldConfigScheme> getAllRelatedSchemes(String optionId) {
        Assertions.notNull((String)"optionId", (Object)optionId);
        List configs = this.fieldConfigSchemeManager.getConfigSchemesForField(this.getField());
        return configs.stream().filter(configScheme -> this.optionSetManager.getOptionsForConfig(this.getFieldConfigForDefaultMapping((FieldConfigScheme)configScheme)).getOptionIds().contains(optionId)).collect(Collectors.toList());
    }

    public Priority getPriority(String priorityId) {
        Assertions.notNull((String)"priorityId", (Object)priorityId);
        return this.constantsManager.getPriorityObject(priorityId);
    }

    public Collection<Priority> getPrioritiesFromIds(Collection<String> priorityIds) {
        Assertions.notNull((String)"priorityIds", priorityIds);
        return (Collection)priorityIds.stream().map(this::getPriority).filter(Objects::nonNull).collect(CollectorsUtil.toImmutableList());
    }

    private void triggerSchemeUpdated(FieldConfigScheme configScheme) {
        this.getFieldManager().refresh();
        this.eventPublisher.publish((Object)new PrioritySchemeUpdatedEvent(configScheme));
    }

    private String getDefaultPriorityOrMiddleOne(FieldConfig fieldConfig) {
        List<String> priorities;
        if (Objects.isNull(fieldConfig)) {
            return null;
        }
        String defaultPriority = this.getDefaultOption(fieldConfig);
        if (Objects.isNull(defaultPriority) && !(priorities = this.getOptions(fieldConfig)).isEmpty()) {
            defaultPriority = priorities.get(Math.max((priorities.size() + 1) / 2 - 1, 0));
        }
        return defaultPriority;
    }

    private Priority getValue(String priorityId) {
        return this.constantsManager.getPriorityObject(priorityId);
    }

    public void assignProject(@Nonnull FieldConfigScheme priorityFieldConfig, @Nonnull Project project) {
        this.assignProjects(priorityFieldConfig, (Set<Project>)ImmutableSet.of((Object)project));
    }

    public void assignProjects(@Nonnull FieldConfigScheme priorityFieldConfig, @Nonnull Set<Project> projects) {
        Preconditions.checkArgument((boolean)PrioritySchemeManagerImpl.isPriorityScheme(priorityFieldConfig));
        if (projects.isEmpty()) {
            return;
        }
        List projectContexts = Sets.union(this.getProjectsWithScheme(priorityFieldConfig), projects).stream().map(project -> new ProjectContext(project.getId(), this.projectManager)).collect(Collectors.toList());
        this.fieldConfigSchemeManager.updateFieldConfigScheme(priorityFieldConfig, projectContexts, priorityFieldConfig.getField());
    }

    @Nonnull
    public Set<Project> getProjectsWithScheme(@Nonnull FieldConfigScheme fieldConfigScheme) {
        Preconditions.checkArgument((boolean)PrioritySchemeManagerImpl.isPriorityScheme((FieldConfigScheme)Preconditions.checkNotNull((Object)fieldConfigScheme)));
        return this.getAllProjects().stream().filter(p -> this.isProjectAssociatedWithScheme(fieldConfigScheme, (Project)p)).collect(Collectors.toSet());
    }

    public void unassignProject(@Nonnull FieldConfigScheme scheme, @Nonnull Project project) {
        this.unassignProjects(scheme, (Set<Project>)ImmutableSet.of((Object)project));
    }

    public void unassignProjects(@Nonnull FieldConfigScheme scheme, @Nonnull Set<Project> projects) {
        Preconditions.checkArgument((boolean)PrioritySchemeManagerImpl.isPriorityScheme(scheme));
        if (projects.isEmpty()) {
            return;
        }
        List projectContexts = projects.stream().map(project -> new ProjectContext(project.getId(), this.projectManager)).collect(Collectors.toList());
        this.fieldConfigSchemeManager.removeSchemeAssociation(projectContexts, scheme.getField());
    }

    private static boolean isPriorityScheme(FieldConfigScheme scheme) {
        FieldConfig fieldConfig = scheme.getOneAndOnlyConfig();
        return "priority".equals(scheme.getField().getId()) && fieldConfig != null && "priority".equals(fieldConfig.getFieldId());
    }

    private boolean isProjectAssociatedWithScheme(FieldConfigScheme scheme, Project project) {
        FieldConfigScheme currentScheme = this.fieldConfigSchemeManager.getRelevantConfigScheme(project, scheme.getField());
        return currentScheme != null && Objects.equals(currentScheme.getId(), scheme.getId());
    }

    private FieldManager getFieldManager() {
        return (FieldManager)this.fieldManagerRef.get();
    }

    private boolean isPrioritiesPerProjectEnabled() {
        return this.featureManager.isEnabled(JiraFeatureFlagRegistrar.PRIORITIES_PER_PROJECT);
    }

    private ConfigurableField<?> getField() {
        return this.getFieldManager().getConfigurableField("priority");
    }

    private Long getDefaultSchemeId() {
        String s = ((ApplicationProperties)this.applicationPropertiesRef.get()).getString("jira.scheme.default.priority");
        return Optional.ofNullable(s).map(Long::parseLong).orElse(null);
    }

    private Comparator<FieldConfigScheme> schemeComparator() {
        return this.defaultIdFirst().thenComparing(BY_NAME_NULLS_FIRST);
    }

    private Comparator<FieldConfigScheme> defaultIdFirst() {
        Long defaultId = this.getDefaultSchemeId();
        return Comparator.comparing(FieldConfigScheme::getId, (id1, id2) -> {
            if (Objects.nonNull(defaultId)) {
                if (defaultId.equals(id1)) {
                    return -1;
                }
                if (defaultId.equals(id2)) {
                    return 1;
                }
            }
            return 0;
        });
    }

    private List<Project> getAllProjects() {
        return Stream.concat(this.projectManager.getProjects().stream(), this.projectManager.getArchivedProjects().stream()).collect(Collectors.toList());
    }
}

