/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.NavigableFieldImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThumbnailSystemField
extends NavigableFieldImpl {
    private static final Logger log = LoggerFactory.getLogger(ThumbnailSystemField.class);
    private final ThumbnailManager thumbnailManager;

    public ThumbnailSystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, ThumbnailManager thumbnailManager, JiraAuthenticationContext authenticationContext) {
        super("thumbnail", "issue.field.thumbnail", "issue.column.heading.thumbnail", templatingEngine, applicationProperties, authenticationContext);
        this.thumbnailManager = thumbnailManager;
    }

    public LuceneFieldSorter getSorter() {
        return null;
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        velocityParams.put("charset", this.getApplicationProperties().getEncoding());
        try {
            velocityParams.put("thumbnails", this.thumbnailManager.getThumbnails(issue, this.getAuthenticationContext().getUser()));
            velocityParams.put("applicationProperties", this.getApplicationProperties());
        }
        catch (Exception e) {
            log.error("Error occurred while generating thumbnails for issue with id '" + issue.getId() + "'.", (Throwable)e);
        }
        return this.renderTemplate("thumbnail-columnview.vm", velocityParams);
    }
}

