/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.export.ExportableSystemField;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.fields.AbstractOrderableNavigableFieldImpl;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.IssueConstantsField;
import com.atlassian.jira.issue.fields.RequirableField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.PriorityRestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.PriorityJsonBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.fields.util.PrioritySchemeUtil;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.handlers.PrioritySearchHandlerFactory;
import com.atlassian.jira.issue.statistics.PriorityStatisticsMapper;
import com.atlassian.jira.issue.statistics.ReversePriorityStatisticsMapper;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.mail.util.MailAttachmentsManagerImpl;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.BaseUrl;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.google.common.collect.ImmutableList;
import com.opensymphony.util.TextUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.Action;

public class PrioritySystemField
extends AbstractOrderableNavigableFieldImpl<Priority>
implements ConfigurableField<Priority>,
HideableField,
RequirableField,
IssueConstantsField,
RestAwareField,
RestFieldOperations,
ExportableSystemField {
    private static final Logger log = LoggerFactory.getLogger(PrioritySystemField.class);
    private static final String PRIORITY_NAME_KEY = "issue.field.priority";
    private final ConstantsManager constantsManager;
    private final PriorityStatisticsMapper priorityStatisticsMapper;
    private final JiraBaseUrls jiraBaseUrls;
    private final BaseUrl baseUrl;
    private final PrioritySchemeManager prioritySchemeManager;
    private final I18nHelper.BeanFactory beanFactory;
    private final PrioritySchemeUtil prioritySchemeUtil;

    public PrioritySystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, ConstantsManager constantsManager, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, PrioritySearchHandlerFactory handlerFactory, JiraBaseUrls jiraBaseUrls, BaseUrl baseUrl, PrioritySchemeManager prioritySchemeManager, I18nHelper.BeanFactory beanFactory, PrioritySchemeUtil prioritySchemeUtil) {
        super("priority", PRIORITY_NAME_KEY, templatingEngine, applicationProperties, authenticationContext, permissionManager, handlerFactory);
        this.constantsManager = constantsManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.baseUrl = baseUrl;
        this.priorityStatisticsMapper = new ReversePriorityStatisticsMapper(constantsManager);
        this.prioritySchemeManager = prioritySchemeManager;
        this.beanFactory = beanFactory;
        this.prioritySchemeUtil = prioritySchemeUtil;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        return this.getEditHtml(fieldLayoutItem, operationContext, action, issue, displayParameters);
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Collection priorities = this.prioritySchemeManager.getPrioritiesFromIds((Collection)this.prioritySchemeManager.getOptions((IssueContext)issue));
        return this.getEditHtml(fieldLayoutItem, operationContext, action, issue, displayParameters, priorities, true);
    }

    private String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters, Collection<Priority> priorities, boolean displayNotAvailable) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        velocityParams.put(this.getId(), operationContext.getFieldValuesHolder().get(this.getId()));
        ArrayList<Priority> priorityConstants = new ArrayList<Priority>(priorities);
        if (displayNotAvailable && Objects.nonNull(issue) && Objects.nonNull(issue.getPriority()) && !priorities.contains(issue.getPriority())) {
            priorityConstants.add(issue.getPriority());
            velocityParams.put("priorityNotAvailable", issue.getPriority());
        }
        velocityParams.put("priorities", priorityConstants);
        return this.renderTemplate("priority-edit.vm", velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        Priority priority = issue.getPriorityObject();
        velocityParams.put("priority", priority);
        this.fillPriorityNotAvailable(issue, velocityParams);
        return this.getViewHtml(velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Priority priority, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, null, displayParameters);
        velocityParams.put("priority", priority);
        this.fillPriorityNotAvailable(issue, velocityParams);
        return this.getViewHtml(velocityParams);
    }

    private void fillPriorityNotAvailable(Issue issue, Map velocityParams) {
        Collection priorities = this.prioritySchemeManager.getPrioritiesFromIds((Collection)this.prioritySchemeManager.getOptions((IssueContext)issue));
        if (Objects.nonNull(issue) && Objects.nonNull(issue.getPriority()) && !priorities.contains(issue.getPriority())) {
            velocityParams.put("priorityNotAvailable", true);
        }
    }

    private String getViewHtml(Map velocityParams) {
        return this.renderTemplate("priority-view.vm", velocityParams);
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        String priorityId = (String)fieldValuesHolder.get(this.getId());
        if (priorityId == null && fieldScreenRenderLayoutItem.isRequired()) {
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("issue.field.required", i18n.getText(this.getNameKey())));
        } else if (priorityId != null) {
            Priority priority = this.getValueFromParams(fieldValuesHolder);
            if (Objects.isNull(priority)) {
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("field.error.invalidpriority"));
            } else {
                HashSet<String> validOptions = new HashSet<String>(this.prioritySchemeManager.getOptions((IssueContext)issue));
                if (Objects.nonNull(issue.getPriority())) {
                    validOptions.add(issue.getPriority().getId());
                }
                if (validOptions.stream().noneMatch(pid -> priority.getId().equals(pid))) {
                    errorCollectionToAddTo.addError(this.getId(), i18n.getText("field.error.invalidpriority.not.in.scheme"));
                }
            }
        }
    }

    public Priority getValueFromParams(Map params) {
        String priorityId = (String)params.get(this.getId());
        if (TextUtils.stringSet((String)priorityId)) {
            return this.constantsManager.getPriorityObject(priorityId);
        }
        return null;
    }

    public void populateParamsFromString(Map<String, Object> fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
        Long priorityId = null;
        try {
            priorityId = Long.valueOf(stringValue);
        }
        catch (NumberFormatException e) {
            priorityId = this.getPriorityTypeIdByName(stringValue);
        }
        fieldValuesHolder.put(this.getId(), priorityId.toString());
    }

    private Long getPriorityTypeIdByName(String stringValue) throws FieldValidationException {
        for (Priority priority : this.constantsManager.getPriorities()) {
            if (!stringValue.equalsIgnoreCase(priority.getName())) continue;
            return Long.valueOf(priority.getId());
        }
        throw new FieldValidationException("Invalid priority name '" + stringValue + "'.");
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        Object currentValue = modifiedValue.getOldValue();
        Object value = modifiedValue.getNewValue();
        ChangeItemBean cib = null;
        if (currentValue == null) {
            if (value != null) {
                Priority priority = (Priority)value;
                cib = new ChangeItemBean("jira", this.getId(), null, null, priority.getId(), priority.getName());
            }
        } else if (!this.valuesEqual(value, currentValue)) {
            Priority currentPriority = (Priority)currentValue;
            if (value != null) {
                Priority priority = (Priority)value;
                cib = new ChangeItemBean("jira", this.getId(), currentPriority.getId(), this.getPriorityName(issue, currentPriority), priority.getId(), priority.getName());
            } else {
                cib = new ChangeItemBean("jira", this.getId(), currentPriority.getId(), this.getPriorityName(issue, currentPriority), null, null);
            }
        }
        if (cib != null) {
            issueChangeHolder.addChangeItem(cib);
        }
    }

    private String getPriorityName(Issue issue, Priority priority) {
        boolean priorityValidInScheme = this.prioritySchemeManager.getOptions((IssueContext)issue).stream().anyMatch(id -> id.equals(priority.getId()));
        if (priorityValidInScheme) {
            return priority.getName();
        }
        return this.getI18nHelperForDefaultLocale().getText("priority.edit.priority.not.available.in.scheme", priority.getName());
    }

    private I18nHelper getI18nHelperForDefaultLocale() {
        Locale defaultLocale = Optional.ofNullable(this.getApplicationProperties().getDefaultLocale()).orElseGet(() -> Locale.getDefault());
        return this.beanFactory.getInstance(defaultLocale);
    }

    public void createValue(Issue issue, Priority value) {
    }

    @Override
    protected Object getRelevantParams(Map<String, String[]> params) {
        String[] value = params.get(this.getId());
        if (value != null && value.length > 0) {
            return value[0];
        }
        return null;
    }

    public void populateFromIssue(Map<String, Object> fieldValuesHolder, Issue issue) {
        Priority priority = issue.getPriority();
        if (priority != null) {
            fieldValuesHolder.put(this.getId(), priority.getId());
        } else {
            fieldValuesHolder.put(this.getId(), null);
        }
    }

    public boolean isShown(Issue issue) {
        return true;
    }

    public void populateDefaults(Map<String, Object> fieldValuesHolder, Issue issue) {
        Priority defaultPriority = this.getDefaultValue(issue);
        if (defaultPriority != null) {
            fieldValuesHolder.put(this.getId(), defaultPriority.getId());
        } else {
            fieldValuesHolder.put(this.getId(), null);
        }
    }

    public Priority getDefaultValue(Issue issue) {
        return this.getPriority(this.prioritySchemeManager.getDefaultOption((IssueContext)issue));
    }

    public Priority getDefaultValue(IssueContext issueContext) {
        return this.getPriority(this.prioritySchemeManager.getDefaultOption(issueContext));
    }

    public Priority getDefaultPriority() {
        return this.constantsManager.getDefaultPriority();
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        if (fieldValueHolder.containsKey(this.getId())) {
            issue.setPriorityObject(this.getValueFromParams(fieldValueHolder));
        }
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        for (Object originalIssue1 : originalIssues) {
            Issue originalIssue = (Issue)originalIssue1;
            if (originalIssue.getPriority() != null || !targetFieldLayoutItem.isRequired()) continue;
            return new MessagedResult(true);
        }
        for (Issue issue : originalIssues) {
            List validPriorityIds;
            if (issue.getProjectId().equals(targetIssue.getProjectId()) || !(validPriorityIds = this.prioritySchemeManager.getOptions((IssueContext)targetIssue)).stream().noneMatch(pid -> pid.equals(Optional.ofNullable(issue.getPriority()).map(IssueConstant::getId).orElse(null)))) continue;
            return new MessagedResult(true);
        }
        return new MessagedResult(false);
    }

    public void populateForMove(Map<String, Object> fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
        this.populateDefaults(fieldValuesHolder, targetIssue);
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        issue.setPriority(null);
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return true;
    }

    public boolean hasValue(Issue issue) {
        return issue.getPriority() != null;
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        for (FieldLayout fieldLayout : bulkEditBean.getFieldLayouts()) {
            if (!fieldLayout.isFieldHidden(this.getId())) continue;
            return "bulk.edit.unavailable.hidden";
        }
        for (Issue issue : bulkEditBean.getSelectedIssues()) {
            if (this.hasBulkUpdatePermission(bulkEditBean, issue) && this.isShown(issue)) continue;
            return "bulk.edit.multiproject.unavailable.permission";
        }
        List<Priority> commonPriorities = this.prioritySchemeUtil.getCommonPrioritiesSorted(bulkEditBean.getProjectObjects());
        if (commonPriorities.isEmpty()) {
            return "bulk.edit.no.common.priorities.error";
        }
        return null;
    }

    @Override
    public String getBulkEditHtml(OperationContext operationContext, Action action, BulkEditBean bulkEditBean, Map displayParameters) {
        this.validateBulkEditHtmlProperties(bulkEditBean);
        if (!"BulkEdit".equals(bulkEditBean.getOperationName()) && !"BulkMove".equals(bulkEditBean.getOperationName())) {
            return super.getBulkEditHtml(operationContext, action, bulkEditBean, displayParameters);
        }
        Issue issue = this.getIssueForBulkOperation(bulkEditBean);
        FieldLayoutItem fieldLayoutItem = this.getFieldLayoutItemForBulkOperation(bulkEditBean);
        Collection projects = "BulkMove".equals(bulkEditBean.getOperationName()) ? ImmutableList.of((Object)bulkEditBean.getTargetProject()) : bulkEditBean.getProjectObjects();
        List<Priority> priorities = this.prioritySchemeUtil.getCommonPrioritiesSorted(projects);
        return this.getEditHtml(fieldLayoutItem, operationContext, action, issue, displayParameters, priorities, false);
    }

    public String getColumnHeadingKey() {
        return "issue.column.heading.priority";
    }

    public String getDefaultSortOrder() {
        return "DESC";
    }

    public LuceneFieldSorter getSorter() {
        return this.priorityStatisticsMapper;
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        Optional<Priority> priority = Optional.ofNullable(issue.getPriority());
        velocityParams.put(this.getId(), priority);
        boolean emailView = Optional.ofNullable((Boolean)displayParams.get("email_view")).orElse(false);
        Optional iconUrl = emailView ? priority.flatMap(p -> this.getIconUrlForEmail((Priority)p, displayParams)) : priority.flatMap(this::getAbsoluteIconUrl);
        velocityParams.put("iconurl", iconUrl);
        return this.renderTemplate("priority-columnview.vm", velocityParams);
    }

    private Optional<String> getAbsoluteIconUrl(Priority priority) {
        try {
            String strippedIssueTypeIconUrl = StringUtils.stripStart((String)priority.getIconUrl(), (String)"/");
            URI issueTypeIconUri = URI.create(strippedIssueTypeIconUrl);
            String absoluteUrl = StringEscapeUtils.escapeHtml4((String)this.baseUrl.getBaseUri().resolve(issueTypeIconUri).toString());
            return Optional.ofNullable(absoluteUrl);
        }
        catch (Exception e) {
            log.warn("Unable to get URI for priority. Probably the URI provided is malformed.");
            return Optional.empty();
        }
    }

    private Optional<String> getIconUrlForEmail(Priority priority, Map<String, Object> displayParams) {
        Optional<MailAttachmentsManagerImpl> mailAttachmentsManager = Optional.ofNullable((MailAttachmentsManagerImpl)displayParams.get("attachmentsManager"));
        return mailAttachmentsManager.map(manager -> manager.getImageUrl(priority.getRasterIconUrl()));
    }

    public Collection getIssueConstants() {
        return this.constantsManager.getPriorityObjects();
    }

    @Override
    public String prettyPrintChangeHistory(String changeHistory, I18nHelper i18nHelper) {
        Priority priority;
        Long priorityId;
        if (TextUtils.stringSet((String)changeHistory) && (priorityId = this.getPriorityTypeIdByName(changeHistory)) != null && (priority = this.constantsManager.getPriorityObject(priorityId.toString())) != null) {
            return priority.getNameTranslation(i18nHelper);
        }
        return changeHistory;
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        Collection priorities = this.prioritySchemeManager.getPrioritiesFromIds((Collection)this.prioritySchemeManager.getOptions(fieldTypeInfoContext.getIssueContext()));
        ArrayList<Priority> priorityConstants = new ArrayList<Priority>(priorities.size());
        for (Priority priority : priorities) {
            priorityConstants.add(priority);
        }
        return new FieldTypeInfo(priorityConstants, null);
    }

    public JsonType getJsonSchema() {
        return PrioritySystemField.getPriorityJsonSchema();
    }

    public static JsonType getPriorityJsonSchema() {
        return JsonTypeBuilder.system((String)"priority", (String)"priority");
    }

    public RestFieldOperationsHandler getRestFieldOperation() {
        return new PriorityRestFieldOperationsHandler(this.constantsManager, this.authenticationContext.getI18nHelper());
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        return new FieldJsonRepresentation(new JsonData((Object)PriorityJsonBean.shortBean((Priority)issue.getPriorityObject(), (JiraBaseUrls)this.jiraBaseUrls)));
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx) {
        Priority priority = this.getPriority(this.prioritySchemeManager.getDefaultOption(issueCtx));
        if (priority != null) {
            return new JsonData((Object)priority);
        }
        return null;
    }

    @Override
    public FieldExportParts getRepresentationFromIssue(Issue issue) {
        Priority priority = issue.getPriority();
        String value = priority != null ? priority.getNameTranslation() : "";
        return FieldExportPartsBuilder.buildSinglePartRepresentation((String)this.getId(), (String)this.getName(), (String)value);
    }

    public List<FieldConfigItemType> getConfigurationItemTypes() {
        return ImmutableList.of();
    }

    public List<Project> getAssociatedProjectObjects() {
        return ((FieldConfigSchemeManager)ComponentAccessor.getComponent(FieldConfigSchemeManager.class)).getAssociatedProjectObjects((ConfigurableField)this);
    }

    public FieldConfig getRelevantConfig(IssueContext issueContext) {
        return ((FieldConfigSchemeManager)ComponentAccessor.getComponent(FieldConfigSchemeManager.class)).getRelevantConfig(issueContext, (ConfigurableField)this);
    }

    private Priority getPriority(String id) {
        if (Objects.isNull(id)) {
            return null;
        }
        return this.constantsManager.getPriorityObject(id);
    }
}

