/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.export.customfield.layout;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.issue.export.FieldExportPart;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.customfield.layout.IssueSearchCsvExportLayout;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.IssueLinksSystemField;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class IssueSearchCsvExportLayoutBuilder {
    private final Map<Field, FieldMetaData> fields = Maps.newLinkedHashMap();

    public IssueSearchCsvExportLayout build() {
        ArrayList fieldLayouts = Lists.newArrayList();
        for (Field field : this.fields.keySet()) {
            FieldMetaData fieldMeta = this.fields.get(field);
            Map<String, String> fieldHeaders = fieldMeta.getFieldItemHeader();
            Map<String, Integer> fieldMaxCount = fieldMeta.getMaxCount();
            List subFieldLayouts = (List)fieldMeta.getFieldItemOrdering().stream().map(id -> new IssueSearchCsvExportLayout.SubFieldLayout((String)fieldHeaders.get(id), (Integer)fieldMaxCount.get(id), (String)id)).collect(CollectorsUtil.toImmutableList());
            IssueSearchCsvExportLayout.FieldLayout fieldLayout = new IssueSearchCsvExportLayout.FieldLayout(subFieldLayouts, field);
            fieldLayouts.add(fieldLayout);
        }
        return new IssueSearchCsvExportLayout(fieldLayouts);
    }

    public void registerFieldRepresentation(Field field, FieldExportParts fieldRepresentation) {
        if (!this.fields.containsKey(field)) {
            this.fields.put(field, new FieldMetaData());
        }
        this.fields.get(field).registerFieldRepresentation(field, fieldRepresentation);
    }

    private class FieldMetaData {
        List<String> fieldItemOrdering = Lists.newArrayList();
        Map<String, String> fieldItemHeader = Maps.newHashMap();
        Map<String, Integer> maxCount = Maps.newHashMap();

        private FieldMetaData() {
        }

        public void registerFieldRepresentation(Field field, FieldExportParts fieldRepresentation) {
            Integer currentIdInsertionPoint = 0;
            for (FieldExportPart item : fieldRepresentation.getParts()) {
                String id = item.getId();
                int count = (int)item.getValues().count();
                if (!this.fieldItemHeader.containsKey(id)) {
                    this.fieldItemHeader.put(id, item.getItemLabel());
                    this.maxCount.put(id, count);
                } else if (this.maxCount.get(id) < count) {
                    this.maxCount.put(id, count);
                }
                Integer idPositionIndex = this.fieldItemOrdering.indexOf(id);
                if (idPositionIndex == -1) {
                    this.fieldItemOrdering.add(currentIdInsertionPoint, id);
                    currentIdInsertionPoint = currentIdInsertionPoint + 1;
                    continue;
                }
                currentIdInsertionPoint = idPositionIndex + 1;
            }
            if (field instanceof IssueLinksSystemField) {
                Collections.sort(this.fieldItemOrdering);
            }
        }

        public List<String> getFieldItemOrdering() {
            return this.fieldItemOrdering;
        }

        public Map<String, String> getFieldItemHeader() {
            return this.fieldItemHeader;
        }

        public Map<String, Integer> getMaxCount() {
            return this.maxCount;
        }
    }
}

