/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.renderer;

import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.constants.UserFieldSearchConstants;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractUserSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserFilter;
import com.atlassian.jira.user.UserFilterManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.bean.I18nBean;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import webwork.action.Action;

public class UserPickerGroupCustomFieldRenderer
extends AbstractUserSearchRenderer
implements SearchRenderer {
    private static final String KEY_VALUE = "value";
    private static final String KEY_KEY = "key";
    private static final String KEY_RELATED = "related";
    private final CustomField field;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final UserFilterManager userFilterManager;

    public UserPickerGroupCustomFieldRenderer(CustomField field, UserFieldSearchConstants searchConstants, String nameKey, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, UserSearchService searchService, FieldVisibilityManager fieldVisibilityManager, UserManager userManager, PermissionManager permissionManager, UserFilterManager userFilterManager) {
        super(searchConstants, nameKey, velocityRequestContextFactory, applicationProperties, templatingEngine, searchService, userManager, permissionManager);
        this.field = field;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.userFilterManager = userFilterManager;
    }

    public boolean isShown(ApplicationUser user, SearchContext searchContext) {
        return CustomFieldUtils.isShownAndVisible((CustomField)this.getCustomField(), (ApplicationUser)user, (SearchContext)searchContext, (FieldVisibilityManager)this.fieldVisibilityManager);
    }

    @Override
    protected List<Map<String, String>> getSelectedListOptions(ApplicationUser searcher) {
        ArrayList<Map<String, String>> types = new ArrayList<Map<String, String>>();
        I18nBean i18n = new I18nBean(searcher);
        types.add(MapBuilder.newBuilder().add((Object)KEY_VALUE, (Object)i18n.getText("assignee.types.anyuser")).add((Object)KEY_KEY, null).add((Object)KEY_RELATED, (Object)"select.list.none").toHashMap());
        if (searcher != null) {
            types.add(MapBuilder.newBuilder().add((Object)KEY_VALUE, (Object)i18n.getText("assignee.types.currentuser")).add((Object)KEY_KEY, (Object)"issue_current_user").add((Object)KEY_RELATED, (Object)"select.list.none").toHashMap());
        }
        types.add(MapBuilder.newBuilder().add((Object)KEY_VALUE, (Object)i18n.getText("assignee.types.specifyuser")).add((Object)KEY_KEY, (Object)"specificuser").add((Object)KEY_RELATED, (Object)"select.list.user").toHashMap());
        types.add(MapBuilder.newBuilder().add((Object)KEY_VALUE, (Object)i18n.getText("assignee.types.specifygroup")).add((Object)KEY_KEY, (Object)"specificgroup").add((Object)KEY_RELATED, (Object)"select.list.group").toHashMap());
        return types;
    }

    @Override
    protected Map<String, Object> getVelocityParams(ApplicationUser searcher, SearchContext searchContext, FieldLayoutItem fieldLayoutItem, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map<String, Object> params = super.getVelocityParams(searcher, searchContext, fieldLayoutItem, fieldValuesHolder, displayParameters, action);
        params.put("description", this.field.getDescriptionProperty().getViewHtml());
        HashMap fieldValuesMap = Maps.newHashMap();
        fieldValuesMap.put("fieldId", this.field.getId());
        if (!fieldValuesHolder.isEmpty()) {
            String issueTypeIdKey;
            String projectIdKey = SystemSearchConstants.forProject().getUrlParameter();
            if (fieldValuesHolder.containsKey((Object)projectIdKey)) {
                fieldValuesMap.put("projectId", fieldValuesHolder.get((Object)projectIdKey));
            }
            if (fieldValuesHolder.containsKey((Object)(issueTypeIdKey = SystemSearchConstants.forIssueType().getUrlParameter()))) {
                fieldValuesMap.put("issueTypeId", fieldValuesHolder.get((Object)issueTypeIdKey));
            }
        }
        params.put("fieldValuesMap", fieldValuesMap);
        return params;
    }

    @Override
    protected Map<String, Object> addUserGroupSuggestionParams(FieldValuesHolder fieldValuesHolder, ApplicationUser user, SearchContext searchContext, List<String> selectedUsers) {
        UserSearchParams userSearchParams = this.getUserSearchParamsFromSearchContext(user, searchContext);
        HashMap params = Maps.newHashMap();
        this.userSearcherHelper.addUserGroupSuggestionParams(user, selectedUsers, userSearchParams, (Map)params);
        return params;
    }

    private UserSearchParams getUserSearchParamsFromSearchContext(ApplicationUser user, SearchContext searchContext) {
        UserFilter filter;
        FieldConfig fieldConfig = this.field.getReleventConfig(searchContext);
        if (fieldConfig != null && (filter = this.userFilterManager.getFilter(fieldConfig)) != null) {
            Collection projectIds = CustomFieldUtils.getProjectIdsForUser((ApplicationUser)user, (Collection)searchContext.getProjectIds(), (PermissionManager)this.permissionManager, (UserFilter)filter);
            return UserSearchParams.builder().allowEmptyQuery(true).filter(filter).filterByProjectIds(projectIds).build();
        }
        return null;
    }

    @Override
    protected String getEmptyValueKey() {
        return "userpicker.empty";
    }

    private CustomField getCustomField() {
        return this.field;
    }
}

