/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.persistence;

import com.atlassian.core.util.Clock;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.Txn;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.ofbiz.core.entity.GenericValue;

public class OfBizCustomFieldValuePersister
implements CustomFieldValuePersister {
    protected final OfBizDelegator delegator;
    private final Clock clock;
    public static final String ENTITY_VALUE_TYPE = "valuetype";
    public static final String ENTITY_ISSUE_ID = "issue";
    protected static final String ENTITY_CUSTOMFIELD_ID = "customfield";
    protected static final String ENTITY_PARENT_KEY = "parentkey";
    @VisibleForTesting
    static final String ENTITY_UPDATED = "updated";
    public static final String DEFAULT_VALUE_TYPE = "DEFAULT";
    public static final String FIELD_TYPE_STRING = "stringvalue";
    public static final String FIELD_TYPE_TEXT = "textvalue";
    public static final String FIELD_TYPE_DATE = "datevalue";
    public static final String FIELD_TYPE_NUMBER = "numbervalue";
    private static final Map<PersistenceFieldType, String> DB_FIELD_MAPPING = new HashMap<PersistenceFieldType, String>();
    public static final String TABLE_CUSTOMFIELD_VALUE = "CustomFieldValue";
    public static final Long DEFAULT_VALUE_ISSUE_ID;

    public OfBizCustomFieldValuePersister(OfBizDelegator delegator, Clock clock) {
        this.delegator = delegator;
        this.clock = clock;
    }

    public List<Object> getValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType) {
        return this.getValues(field, issueId, persistenceFieldType, null);
    }

    public List<Object> getValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, String parentKey) {
        if (issueId == null) {
            return Collections.emptyList();
        }
        List<GenericValue> genericValues = this.getValuesForTypeAndParent(field, issueId, parentKey);
        return OfBizCustomFieldValuePersister.getValuesFromGenericValues(genericValues, persistenceFieldType);
    }

    public Set<Long> getIssueIdsWithValue(CustomField field, PersistenceFieldType persistenceFieldType, Object value) {
        HashMap<String, Object> limitClause = new HashMap<String, Object>();
        limitClause.put(ENTITY_VALUE_TYPE, null);
        limitClause.put(ENTITY_CUSTOMFIELD_ID, CustomFieldUtils.getCustomFieldId((String)field.getId()));
        limitClause.put(OfBizCustomFieldValuePersister.getColumnName(persistenceFieldType), value);
        List genericValues = this.delegator.findByAnd(TABLE_CUSTOMFIELD_VALUE, limitClause);
        HashSet<Long> ids = new HashSet<Long>();
        for (GenericValue genericValue : genericValues) {
            ids.add(genericValue.getLong(ENTITY_ISSUE_ID));
        }
        return ids;
    }

    private static List<Object> getValuesFromGenericValues(List<GenericValue> genericValues, PersistenceFieldType persistenceFieldType) {
        ArrayList<Object> values = new ArrayList<Object>(genericValues.size());
        for (GenericValue genericValue : genericValues) {
            values.add(genericValue.get(OfBizCustomFieldValuePersister.getColumnName(persistenceFieldType)));
        }
        return values;
    }

    public void createValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Collection values) {
        this.createValues(field, issueId, persistenceFieldType, values, null);
    }

    public void createValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Collection values, String parentKey) {
        this.updateValues(field, issueId, persistenceFieldType, values, parentKey);
    }

    private void createValuesInt(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Collection values, String parentKey) {
        if (values == null) {
            return;
        }
        long time = this.clock.getCurrentDate().getTime();
        for (Object value : values) {
            if (value == null || "".equals(value) || "-1".equals(value)) continue;
            HashMap<String, Object> entityFields = new HashMap<String, Object>();
            entityFields.put(ENTITY_ISSUE_ID, issueId);
            entityFields.put(ENTITY_PARENT_KEY, parentKey);
            entityFields.put(ENTITY_CUSTOMFIELD_ID, CustomFieldUtils.getCustomFieldId((String)field.getId()));
            entityFields.put(OfBizCustomFieldValuePersister.getColumnName(persistenceFieldType), value);
            entityFields.put(ENTITY_UPDATED, time);
            this.delegator.createValue(TABLE_CUSTOMFIELD_VALUE, entityFields);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Collection values) {
        Transaction transaction = Txn.begin();
        try {
            List<GenericValue> GVs = this.getValuesForType(field, issueId);
            if (CollectionUtils.isNotEmpty((Collection)values)) {
                this.createValuesInt(field, issueId, persistenceFieldType, values, null);
            }
            this.delegator.removeAll(GVs);
            transaction.commit();
        }
        finally {
            transaction.finallyRollbackIfNotCommitted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Collection values, String parentKey) {
        Transaction transaction = Txn.begin();
        try {
            List<GenericValue> GVs = this.getValuesForTypeAndParent(field, issueId, parentKey);
            if (CollectionUtils.isNotEmpty((Collection)values)) {
                this.createValuesInt(field, issueId, persistenceFieldType, values, parentKey);
            }
            this.delegator.removeAll(GVs);
            transaction.commit();
        }
        finally {
            transaction.finallyRollbackIfNotCommitted();
        }
    }

    public Set<Long> removeValue(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Object value) {
        Map limitClause = MapBuilder.build((Object)ENTITY_CUSTOMFIELD_ID, (Object)CustomFieldUtils.getCustomFieldId((String)field.getId()), (Object)ENTITY_ISSUE_ID, (Object)issueId, (Object)OfBizCustomFieldValuePersister.getColumnName(persistenceFieldType), (Object)value);
        List values = this.delegator.findByAnd(TABLE_CUSTOMFIELD_VALUE, limitClause);
        HashSet<Long> issues = new HashSet<Long>();
        ArrayList<GenericValue> deleteThese = new ArrayList<GenericValue>();
        for (GenericValue valueGV : values) {
            issues.add(valueGV.getLong(ENTITY_ISSUE_ID));
            deleteThese.add(valueGV);
        }
        this.delegator.removeAll(deleteThese);
        return issues;
    }

    public Set<Long> removeAllValues(String customFieldId) {
        Assertions.notNull((String)"customFieldId", (Object)customFieldId);
        Map limitClause = MapBuilder.build((Object)ENTITY_CUSTOMFIELD_ID, (Object)CustomFieldUtils.getCustomFieldId((String)customFieldId));
        List values = this.delegator.findByAnd(TABLE_CUSTOMFIELD_VALUE, limitClause);
        HashSet<Long> issues = new HashSet<Long>();
        ArrayList<GenericValue> deleteThese = new ArrayList<GenericValue>();
        for (GenericValue valueGV : values) {
            Long aLong = valueGV.getLong(ENTITY_ISSUE_ID);
            if (!aLong.equals(DEFAULT_VALUE_ISSUE_ID)) {
                issues.add(aLong);
            }
            deleteThese.add(valueGV);
        }
        this.delegator.removeAll(deleteThese);
        return issues;
    }

    protected List<GenericValue> getValuesForTypeAndParent(CustomField field, Long issueId, String parentKey) {
        Map limitClause = MapBuilder.build((Object)ENTITY_ISSUE_ID, (Object)issueId, (Object)ENTITY_CUSTOMFIELD_ID, (Object)CustomFieldUtils.getCustomFieldId((String)field.getId()), (Object)ENTITY_PARENT_KEY, (Object)parentKey);
        List gvs = this.delegator.findByAnd(TABLE_CUSTOMFIELD_VALUE, limitClause);
        gvs.sort(new CustomFieldUpdatedComparator());
        return gvs;
    }

    protected List<GenericValue> getValuesForType(CustomField field, Long issueId) {
        Map limitClause = MapBuilder.build((Object)ENTITY_ISSUE_ID, (Object)issueId, (Object)ENTITY_CUSTOMFIELD_ID, (Object)CustomFieldUtils.getCustomFieldId((String)field.getId()));
        List gvs = this.delegator.findByAnd(TABLE_CUSTOMFIELD_VALUE, limitClause);
        gvs.sort(new CustomFieldUpdatedComparator());
        return gvs;
    }

    private static String getColumnName(PersistenceFieldType persistenceFieldType) {
        String columnName = DB_FIELD_MAPPING.get(persistenceFieldType);
        if (columnName == null) {
            throw new IllegalArgumentException("PersistenceFieldType '" + persistenceFieldType + "' not supported. Supported types: '" + DB_FIELD_MAPPING.keySet() + "'");
        }
        return columnName;
    }

    static {
        DB_FIELD_MAPPING.put(PersistenceFieldType.TYPE_DATE, FIELD_TYPE_DATE);
        DB_FIELD_MAPPING.put(PersistenceFieldType.TYPE_DECIMAL, FIELD_TYPE_NUMBER);
        DB_FIELD_MAPPING.put(PersistenceFieldType.TYPE_LIMITED_TEXT, FIELD_TYPE_STRING);
        DB_FIELD_MAPPING.put(PersistenceFieldType.TYPE_UNLIMITED_TEXT, FIELD_TYPE_TEXT);
        DEFAULT_VALUE_ISSUE_ID = -1L;
    }

    static class CustomFieldUpdatedComparator
    implements Comparator<GenericValue> {
        CustomFieldUpdatedComparator() {
        }

        @Override
        public int compare(GenericValue o1, GenericValue o2) {
            int comparisonResult = this.compare(o1, o2, OfBizCustomFieldValuePersister.ENTITY_UPDATED);
            if (comparisonResult == 0) {
                comparisonResult = this.compare(o1, o2, "id");
            }
            return comparisonResult;
        }

        private int compare(GenericValue o1, GenericValue o2, String attribute) {
            Long o2Value;
            Long o1Value = o1 == null ? null : o1.getLong(attribute);
            Long l = o2Value = o2 == null ? null : o2.getLong(attribute);
            if (o1Value != null && o2Value != null) {
                return Long.signum(o1Value - o2Value);
            }
            if (o1Value == null && o2Value == null) {
                return 0;
            }
            if (o1Value == null) {
                return -1;
            }
            return 1;
        }
    }
}

