/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.persistence;

import com.atlassian.core.util.Clock;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.persistence.OfBizCustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilMisc;

public class EagerLoadingOfBizCustomFieldPersister
extends OfBizCustomFieldValuePersister {
    static final String CUSTOMFIELD_VALUES_CACHE_MAX_SIZE = "jira.customfield.values.cache.max.size";
    private final JiraProperties properties;

    public EagerLoadingOfBizCustomFieldPersister(OfBizDelegator delegator, Clock clock, JiraProperties properties) {
        super(delegator, clock);
        this.properties = properties;
    }

    @Override
    public void createValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Collection values) {
        super.createValues(field, issueId, persistenceFieldType, values);
        this.clearCache();
    }

    @Override
    public void createValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Collection values, String parentKey) {
        super.createValues(field, issueId, persistenceFieldType, values, parentKey);
        this.clearCache();
    }

    @Override
    public void updateValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Collection values) {
        super.updateValues(field, issueId, persistenceFieldType, values);
        this.clearCache();
    }

    @Override
    public void updateValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Collection values, String parentKey) {
        super.updateValues(field, issueId, persistenceFieldType, values, parentKey);
        this.clearCache();
    }

    @Override
    public Set<Long> removeValue(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Object value) {
        Set<Long> set = super.removeValue(field, issueId, persistenceFieldType, value);
        this.clearCache();
        return set;
    }

    public Set removeAllValues(String customFieldId) {
        Set<Long> set = super.removeAllValues(customFieldId);
        this.clearCache();
        return set;
    }

    public void clearCache() {
        this.getCache().invalidateAll();
    }

    @Override
    protected List<GenericValue> getValuesForTypeAndParent(CustomField field, Long issueId, String parentKey) {
        List<GenericValue> cachedValuesForIssue = this.getValuesForIssueId(issueId);
        return EntityUtil.filterByAnd(cachedValuesForIssue, (Map)UtilMisc.toMap((String)"customfield", (Object)CustomFieldUtils.getCustomFieldId((String)field.getId()), (String)"parentkey", (Object)parentKey));
    }

    @Override
    protected List<GenericValue> getValuesForType(CustomField field, Long issueId) {
        List<GenericValue> cachedValuesForIssue = this.getValuesForIssueId(issueId);
        return EntityUtil.filterByAnd(cachedValuesForIssue, (Map)UtilMisc.toMap((String)"customfield", (Object)CustomFieldUtils.getCustomFieldId((String)field.getId())));
    }

    private List<GenericValue> getValuesForIssueId(Long issueId) {
        Cache<CacheKey, List<GenericValue>> queryToResultsCache = this.getCache();
        CacheKey key = new CacheKey(issueId);
        try {
            return (List)queryToResultsCache.get((Object)key, () -> {
                ImmutableMap limitClause = ImmutableMap.of((Object)"issue", (Object)issueId);
                ArrayList<GenericValue> cachedValuesForIssue = new ArrayList<GenericValue>(this.delegator.findByAnd("CustomFieldValue", (Map)limitClause));
                cachedValuesForIssue.sort(new OfBizCustomFieldValuePersister.CustomFieldUpdatedComparator());
                return cachedValuesForIssue;
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private Cache<CacheKey, List<GenericValue>> getCache() {
        return (Cache)JiraAuthenticationContextImpl.getRequestCache("jira.customfield.values.cache", () -> CacheBuilder.newBuilder().maximumSize((long)this.properties.getInteger(CUSTOMFIELD_VALUES_CACHE_MAX_SIZE, Integer.valueOf(10)).intValue()).build());
    }

    static final class CacheKey {
        private final Long issueId;

        CacheKey(Long issueId) {
            this.issueId = issueId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!this.getClass().equals(o.getClass())) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.issueId == null ? cacheKey.issueId == null : this.issueId.equals(cacheKey.issueId);
        }

        public int hashCode() {
            return this.issueId != null ? this.issueId.hashCode() : 0;
        }
    }
}

