/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.manager;

import com.atlassian.jira.issue.customfields.option.SimpleOption;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;

class ImmutableSimpleOption
implements SimpleOption<ImmutableSimpleOption> {
    private final Long id;
    private final String value;
    private final List<ImmutableSimpleOption> children;

    ImmutableSimpleOption(SimpleOption<?> option) {
        this.id = option.getOptionId();
        this.value = option.getValue();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SimpleOption child : option.getChildOptions()) {
            builder.add((Object)new ImmutableSimpleOption(child));
        }
        this.children = builder.build();
    }

    public Long getOptionId() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    @Nonnull
    public List<ImmutableSimpleOption> getChildOptions() {
        return this.children;
    }
}

