/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.manager;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.NotNullHashMap;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.thoughtworks.xstream.security.AnyTypePermission;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGenericConfigManager
implements GenericConfigManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultGenericConfigManager.class);
    private final OfBizDelegator delegator;
    private final XStreamBuilder streamBuilder;

    public DefaultGenericConfigManager(OfBizDelegator delegator, FeatureManager featureManager, JiraProperties jiraProperties) {
        this.delegator = (OfBizDelegator)Assertions.notNull((String)"OfBizDelegator", (Object)delegator);
        this.streamBuilder = new XStreamBuilder(featureManager, jiraProperties);
    }

    public void create(String dataType, String key, @Nullable Object obj) {
        if (obj != null) {
            String xml = this.toXml(obj);
            log.debug(obj + " stored as " + xml);
            Map fields = this.toFieldsMap(dataType, key, xml);
            EntityUtils.createValue("GenericConfiguration", fields);
        }
    }

    public void update(String dataType, String key, @Nullable Object obj) {
        if (obj != null) {
            Map fields = this.toFieldsMap(dataType, key, null);
            try {
                List gvs = this.delegator.findByAnd("GenericConfiguration", fields);
                String xml = this.toXml(obj);
                if (gvs != null && !gvs.isEmpty()) {
                    GenericValue gv = (GenericValue)gvs.iterator().next();
                    gv.setString("xmlvalue", xml);
                    gv.store();
                }
                fields.put("xmlvalue", xml);
                EntityUtils.createValue("GenericConfiguration", fields);
            }
            catch (GenericEntityException e) {
                throw new DataAccessException((Throwable)e);
            }
        } else {
            this.remove(dataType, key);
        }
    }

    public Object retrieve(String dataType, String key) {
        Map fields = this.toFieldsMap(dataType, key, null);
        List gvs = this.delegator.findByAnd("GenericConfiguration", fields);
        if (gvs != null && !gvs.isEmpty()) {
            GenericValue gv = (GenericValue)gvs.iterator().next();
            String xml = gv.getString("xmlvalue");
            return this.fromXml(xml);
        }
        return null;
    }

    public void remove(String dataType, String key) {
        Map fields = this.toFieldsMap(dataType, key, null);
        this.delegator.removeByAnd("GenericConfiguration", fields);
    }

    private Map toFieldsMap(String dataType, String key, String xml) {
        NotNullHashMap<String, String> fields = new NotNullHashMap<String, String>();
        fields.put("datatype", dataType);
        fields.put("datakey", key);
        fields.put("xmlvalue", xml);
        return fields;
    }

    private String toXml(Object obj) {
        if (obj != null) {
            XStream xStream = new XStream();
            xStream.registerConverter((SingleValueConverter)new TimestampConverter());
            String xml = xStream.toXML(obj);
            return xml;
        }
        return null;
    }

    private Object fromXml(String xml) {
        if (StringUtils.isNotEmpty((CharSequence)xml)) {
            XStream xStream = this.streamBuilder.getXStreamInstance();
            xStream.registerConverter((SingleValueConverter)new TimestampConverter());
            return xStream.fromXML(xml);
        }
        return null;
    }

    class XStreamBuilder {
        private static final String JIRA_WHITELIST_FILTERING_DISABLED = "enable.generic.config.serialization.whitelistdisabled";
        private final boolean isOnDemand;
        private final boolean filteringIsEnabled;

        public XStreamBuilder(FeatureManager featureManager, JiraProperties jiraProperties) {
            this.isOnDemand = featureManager.isOnDemand();
            this.filteringIsEnabled = jiraProperties.getBoolean(JIRA_WHITELIST_FILTERING_DISABLED) == false;
        }

        XStream getXStreamInstance() {
            XStream stream = new XStream();
            this.buildBtfXStreamPermissions(stream);
            return stream;
        }

        private void buildBtfXStreamPermissions(XStream stream) {
            stream.addPermission(AnyTypePermission.ANY);
            this.excludeBtfSpecificClasses(stream);
        }

        private void excludeBtfSpecificClasses(XStream stream) {
            String[] blockClasses = new String[]{"org.apache.commons.collections.comparators.TransformingComparator", "org.apache.commons.collections.comparators.ComparableComparator", "org.apache.commons.collections.functors.InvokerTransformer", "org.apache.xalan.xsltc.trax.TemplatesImpl"};
            stream.denyTypes(blockClasses);
        }

        private void buildCloudXStreamPermissions(XStream stream) {
            stream.addPermission(NoTypePermission.NONE);
            stream.addPermission(PrimitiveTypePermission.PRIMITIVES);
            stream.addPermission(NullPermission.NULL);
            this.addCloudSpecificClasses(stream);
        }

        private void addCloudSpecificClasses(XStream stream) {
            Class[] allowedClasses = new Class[]{String.class, Map.class, Set.class, List.class};
            String[] allowedClassesByName = new String[]{"java.sql.Timestamp", "com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl", "java.util.Collections$UnmodifiableList"};
            stream.allowTypes(allowedClasses);
            stream.allowTypes(allowedClassesByName);
        }
    }

    private static class TimestampConverter
    extends AbstractSingleValueConverter {
        private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.S";

        private TimestampConverter() {
        }

        public boolean canConvert(Class type) {
            return type != null && type.equals(Timestamp.class);
        }

        public String toString(Object source) {
            Date date = new Date(((Timestamp)source).getTime());
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            String str = format.format(date);
            return str;
        }

        public Object fromString(String str) {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
            try {
                Date date = formatter.parse(str);
                return new Timestamp(date.getTime());
            }
            catch (ParseException e) {
                log.error("Could not parse {} as Timestamp", (Object)str);
                return null;
            }
        }
    }
}

