/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.config.item;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.impl.VersionCFType;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.option.GenericImmutableOptions;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.util.I18nHelper;
import io.atlassian.fugue.Option;
import java.util.Collections;

public class VersionOrderConfigItem
implements FieldConfigItemType {
    private final VersionManager versionManager;
    private final GenericConfigManager genericConfigManager;
    private final I18nHelper i18nHelper;

    public VersionOrderConfigItem(VersionManager versionManager, GenericConfigManager genericConfigManager, I18nHelper i18nHelper) {
        this.versionManager = versionManager;
        this.genericConfigManager = genericConfigManager;
        this.i18nHelper = i18nHelper;
    }

    public String getDisplayName() {
        return "";
    }

    public String getDisplayNameKey() {
        return "admin.issuefields.customfields.versionorder";
    }

    public String getViewHtml(FieldConfig fieldConfig, FieldLayoutItem fieldLayoutItem) {
        Object versionOrderId = this.genericConfigManager.retrieve(VersionCFType.VersionOrder.getDatabaseType(), fieldConfig.getId().toString());
        Option<VersionCFType.VersionOrder> version = VersionCFType.VersionOrder.findById(versionOrderId);
        if (version.isDefined()) {
            return ((VersionCFType.VersionOrder)((Object)version.get())).asHtml(this.i18nHelper);
        }
        return VersionCFType.VersionOrder.RELEASED_FIRST.asHtml(this.i18nHelper);
    }

    public String getObjectKey() {
        return "versionOrder";
    }

    public Object getConfigurationObject(Issue issue, FieldConfig config) {
        if (issue != null && issue.getProjectId() != null) {
            return new GenericImmutableOptions(this.versionManager.getVersions(issue.getProjectId()), config);
        }
        return new GenericImmutableOptions(Collections.emptyList(), config);
    }

    public String getBaseEditUrl() {
        return "EditVersionPickerCustomFieldOptionsOrder!default.jspa";
    }
}

