/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.changehistory.metadata.renderer;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadataParticipant;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class HistoryMetadataRenderHelper {
    private final ApplicationProperties applicationProperties;
    private final I18nHelper i18n;

    public HistoryMetadataRenderHelper(ApplicationProperties applicationProperties, I18nHelper i18nHelper) {
        this.applicationProperties = applicationProperties;
        this.i18n = i18nHelper;
    }

    @Nullable
    public String getParticipantAvatarUrl(@Nullable HistoryMetadataParticipant participant) {
        if (participant != null && participant.getAvatarUrl() != null) {
            try {
                URI avatarUri = new URI(participant.getAvatarUrl());
                if (!avatarUri.isAbsolute()) {
                    return StringUtils.stripEnd((String)this.getBaseUrl(), (String)"/") + "/" + StringUtils.stripStart((String)participant.getAvatarUrl(), (String)"/");
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return participant.getAvatarUrl();
        }
        return null;
    }

    private String getBaseUrl() {
        return this.applicationProperties.getString("jira.baseurl");
    }

    @Nullable
    public String getParticipantName(@Nullable HistoryMetadataParticipant participant) {
        if (participant != null) {
            if (this.i18n.isKeyDefined(participant.getDisplayNameKey())) {
                return this.i18n.getText(participant.getDisplayNameKey(), participant.getId());
            }
            if (!Strings.isNullOrEmpty((String)participant.getDisplayName())) {
                return participant.getDisplayName();
            }
            return participant.getId();
        }
        return null;
    }
}

