/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.AttachmentValidator;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import io.atlassian.fugue.Either;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DefaultAttachmentValidator
implements AttachmentValidator {
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final PermissionManager permissionManager;
    private final IssueManager issueManager;
    private final AttachmentManager attachmentManager;

    public DefaultAttachmentValidator(I18nHelper.BeanFactory i18nBeanFactory, PermissionManager permissionManager, IssueManager issueManager, AttachmentManager attachmentManager) {
        this.i18nBeanFactory = i18nBeanFactory;
        this.permissionManager = permissionManager;
        this.issueManager = issueManager;
        this.attachmentManager = attachmentManager;
    }

    public boolean canCreateAttachments(@Nullable ApplicationUser user, Issue issue, ErrorCollection errorCollection) {
        return this.validateAttachmentsEnabled(user, errorCollection) && this.validateCreateAttachmentsWithoutWorkflow(user, issue, errorCollection) && this.validateIssueEditable(user, issue, errorCollection);
    }

    public boolean canCreateTemporaryAttachments(final @Nullable ApplicationUser user, Either<Issue, Project> issueOrProject, final ErrorCollection errorCollection) {
        return this.validateAttachmentsEnabled(user, errorCollection) && (Boolean)issueOrProject.fold((Function)new Function<Issue, Boolean>(){

            @Override
            public Boolean apply(Issue issue) {
                return DefaultAttachmentValidator.this.validateCreateAttachmentsWithoutWorkflow(user, issue, errorCollection);
            }
        }, (Function)new Function<Project, Boolean>(){

            @Override
            public Boolean apply(Project project) {
                return DefaultAttachmentValidator.this.validateCreateTemporaryAttachmentsInProject(user, project, errorCollection);
            }
        }) != false;
    }

    private I18nHelper getI18n(@Nullable ApplicationUser user) {
        return this.i18nBeanFactory.getInstance(user);
    }

    private boolean validateCreateTemporaryAttachmentsInProject(@Nullable ApplicationUser user, Project project, ErrorCollection errorCollection) {
        return this.processValidationResult(this.permissionManager.hasPermission(ProjectPermissions.CREATE_ATTACHMENTS, project, user), "attachment.service.error.create.no.permission.project", user, errorCollection);
    }

    private boolean validateCreateAttachmentsWithoutWorkflow(@Nullable ApplicationUser user, Issue issue, ErrorCollection errorCollection) {
        return this.processValidationResult(this.permissionManager.hasPermission(ProjectPermissions.CREATE_ATTACHMENTS, issue, user), "attachment.service.error.create.no.permission", user, errorCollection);
    }

    private boolean validateAttachmentsEnabled(@Nullable ApplicationUser user, ErrorCollection errorCollection) {
        return this.processValidationResult(this.attachmentManager.attachmentsEnabled(), "attachment.service.error.attachments.disabled", user, errorCollection);
    }

    private boolean validateIssueEditable(@Nullable ApplicationUser user, Issue issue, ErrorCollection errorCollection) {
        return this.processValidationResult(this.issueManager.isEditable(issue), "attachment.service.error.create.issue.non.editable", user, errorCollection);
    }

    private boolean processValidationResult(boolean result, String errorMessageKey, @Nullable ApplicationUser user, ErrorCollection errorCollection) {
        if (!result) {
            errorCollection.addErrorMessage(this.getI18n(user).getText(errorMessageKey));
            return false;
        }
        return true;
    }
}

