/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.archiving.query;

import com.atlassian.jira.issue.archiving.query.ArchiveQuery;
import com.atlassian.jira.issue.archiving.query.ArchiveQueryUtil;
import com.atlassian.jira.issue.archiving.query.ArchivedIssue;
import com.atlassian.jira.issue.archiving.query.AutoCloseableIterator;
import com.atlassian.jira.project.Project;
import java.util.Iterator;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;

class ArchivedProjectsIterator
extends AutoCloseableIterator<ArchivedIssue> {
    private ArchiveQueryUtil archiveQueryUtil;
    private final Stack<Project> projects;
    private final AtomicInteger currentMax;
    private final ArchiveQuery query;
    Iterator<ArchivedIssue> issuesIter;
    Stream<ArchivedIssue> issues;
    ArchivedIssue nextItem;

    public ArchivedProjectsIterator(ArchiveQueryUtil archiveQueryUtil, Stack<Project> projects, AtomicInteger currentMax, ArchiveQuery query) {
        this.archiveQueryUtil = archiveQueryUtil;
        this.projects = projects;
        this.currentMax = currentMax;
        this.query = query;
        this.nextItem = this.popNextItem();
    }

    private ArchivedIssue iterate() {
        ArchivedIssue issue;
        ArchivedIssue archivedIssue = issue = this.issuesIter.hasNext() ? this.issuesIter.next() : null;
        if (!this.issuesIter.hasNext()) {
            this.issues.close();
        }
        return issue;
    }

    private ArchivedIssue popNextItem() {
        ArchivedIssue next;
        if (this.issuesIter != null && this.issuesIter.hasNext()) {
            return this.iterate();
        }
        if (this.projects.isEmpty()) {
            return null;
        }
        do {
            this.popStream();
        } while ((next = this.iterate()) == null && !this.projects.isEmpty());
        return next;
    }

    @Override
    public boolean hasNext() {
        return this.nextItem != null && this.currentMax.get() >= 0;
    }

    @Override
    public ArchivedIssue next() {
        ArchivedIssue next = this.nextItem;
        this.nextItem = this.popNextItem();
        return next;
    }

    @Override
    public void close() throws Exception {
        if (this.issues != null) {
            this.issues.close();
            this.issues = null;
        }
    }

    private void popStream() {
        if (this.issues != null) {
            this.issues.close();
        }
        this.issues = this.archiveQueryUtil.popArchivedProject(this.projects.pop(), this.query, this.currentMax);
        this.issuesIter = this.issues.iterator();
    }
}

