/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.archiving.query;

import com.atlassian.jira.database.DatabaseUtil;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.archiving.query.ArchiveQuery;
import com.atlassian.jira.issue.archiving.query.ArchivedIssue;
import com.atlassian.jira.issue.archiving.query.ArchivedProjectsIterator;
import com.atlassian.jira.issue.archiving.query.ArchivedState;
import com.atlassian.jira.issue.archiving.query.AutoCloseableIterator;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.archiving.ArchivedProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.lucene.util.MergedIterator;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveQueryUtil {
    private static final Logger log = LoggerFactory.getLogger(ArchiveQueryUtil.class);
    private final OfBizDelegator ofBizDelegator;
    private final ProjectManager projectManager;
    private final ArchivedProjectManager archivedProjectManager;
    private final IssueFactory issueFactory;

    public ArchiveQueryUtil(OfBizDelegator ofBizDelegator, ProjectManager projectManager, ArchivedProjectManager archivedProjectManager, IssueFactory issueFactory) {
        this.ofBizDelegator = ofBizDelegator;
        this.projectManager = projectManager;
        this.archivedProjectManager = archivedProjectManager;
        this.issueFactory = issueFactory;
    }

    public Stream<ArchivedIssue> queryArchivedIssues(ArchiveQuery query) {
        Optional<Project> project = query.getProject();
        int maxResults = query.getMaxResults();
        log.info("Get archived projects");
        if (project.isPresent()) {
            log.info("Limit results to project {}", (Object)project.get().getKey());
        }
        log.info("Archive query: {}", (Object)query.toString());
        List archivedProjects = this.projectManager.getArchivedProjects();
        log.info("Selected {} archived projects", (Object)archivedProjects.size());
        Stack<Project> projects = new Stack<Project>();
        project.map(p -> archivedProjects.stream().filter(archivedProject -> archivedProject.getKey().equals(p.getKey()))).orElseGet(archivedProjects::stream).filter(p -> query.getArchivedBy().map(queryArchivedBy -> this.archivedProjectManager.getArchivedBy((Project)p).map(projectArchivedBy -> projectArchivedBy.equals(queryArchivedBy)).orElse(false)).orElse(true)).filter(p -> query.getArchivedAfter().map(archivedAfter -> Optional.ofNullable(this.archivedProjectManager.getArchivedTimestamp((Project)p)).orElse(Long.MAX_VALUE) >= archivedAfter.getTime()).orElse(true)).filter(p -> query.getArchivedBefore().map(archivedBefore -> Optional.ofNullable(this.archivedProjectManager.getArchivedTimestamp((Project)p)).orElse(0L) <= archivedBefore.getTime()).orElse(true)).sorted(Comparator.comparing(this.archivedProjectManager::getArchivedTimestamp)).forEach(projects::push);
        AtomicInteger currentMax = new AtomicInteger(maxResults);
        AutoCloseableIterator<ArchivedIssue> archivedIssues = this.iterateIssues(query, currentMax);
        AutoCloseableIterator<ArchivedIssue> archivedProjectIssues = this.iterateProjectsIssues(projects, query, currentMax);
        Spliterator spliterator = Spliterators.spliterator(new MergedIterator(false, new Iterator[]{archivedIssues, archivedProjectIssues}), (long)currentMax.get(), 16);
        Stream<ArchivedIssue> stream = StreamSupport.stream(spliterator, false);
        return (Stream)((Stream)stream.filter(issue -> currentMax.decrementAndGet() >= 0).onClose(archivedIssues::closeStream)).onClose(archivedProjectIssues::closeStream);
    }

    private AutoCloseableIterator<ArchivedIssue> iterateIssues(ArchiveQuery query, final AtomicInteger currentMax) {
        final Stream<ArchivedIssue> stream = this.iterateStream(this.getArchivedIssues(currentMax.get(), query), currentMax).map(arg_0 -> ((IssueFactory)this.issueFactory).getIssue(arg_0)).map(ArchivedIssue::new);
        final Iterator iterator = stream.iterator();
        return new AutoCloseableIterator<ArchivedIssue>(){

            @Override
            public void close() throws Exception {
                stream.close();
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext() && currentMax.get() >= 0;
            }

            @Override
            public ArchivedIssue next() {
                ArchivedIssue next = (ArchivedIssue)iterator.next();
                if (!iterator.hasNext()) {
                    stream.close();
                }
                return next;
            }
        };
    }

    private AutoCloseableIterator<ArchivedIssue> iterateProjectsIssues(Stack<Project> projects, ArchiveQuery query, AtomicInteger currentMax) {
        return new ArchivedProjectsIterator(this, projects, currentMax, query);
    }

    Stream<ArchivedIssue> popArchivedProject(Project project, ArchiveQuery query, AtomicInteger currentMax) {
        log.debug("Pop archived project: {}", (Object)project.getKey());
        Optional<ApplicationUser> archivedBy = this.archivedProjectManager.getArchivedBy(project);
        Timestamp archivedDate = Optional.ofNullable(this.archivedProjectManager.getArchivedTimestamp(project)).map(Timestamp::new).orElse(null);
        return this.iterateStream(this.getProjectIssues(project, query, currentMax.get()), currentMax).map(genericValue -> {
            MutableIssue issue = this.issueFactory.getIssue(genericValue);
            return new ArchivedIssue((Issue)issue, archivedBy.orElse(null), archivedDate, ArchivedState.PROJECT_ARCHIVED);
        });
    }

    private OfBizListIterator getProjectIssues(Project project, ArchiveQuery query, int maxResults) {
        EntityConditionList whereNotArchived = new EntityConditionList((List)ImmutableList.of((Object)new EntityExpr("archived", EntityOperator.EQUALS, (Object)DatabaseUtil.booleanToChar1(false)), (Object)new EntityExpr("archived", EntityOperator.EQUALS, null)), EntityOperator.OR);
        EntityExpr projectCondition = new EntityExpr("project", EntityOperator.EQUALS, (Object)project.getId());
        projectCondition = this.getQueryConditions(query, (EntityCondition)projectCondition, true);
        log.debug("Open ofbiz iterator");
        return this.ofBizDelegator.findListIteratorByCondition("Issue", (EntityCondition)new EntityConditionList(Arrays.asList(whereNotArchived, projectCondition), EntityOperator.AND), null, null, (List)ImmutableList.of((Object)"number ASC"), EntityFindOptions.findOptions().fetchSize(maxResults));
    }

    private OfBizListIterator getArchivedIssues(int maxResults, ArchiveQuery query) {
        log.info("Get archived issues");
        EntityExpr issuesCondition = new EntityExpr("archived", EntityOperator.EQUALS, (Object)DatabaseUtil.booleanToChar1(true));
        issuesCondition = this.getQueryConditions(query, (EntityCondition)issuesCondition, false);
        log.debug("Open ofbiz iterator");
        return this.ofBizDelegator.findListIteratorByCondition("Issue", (EntityCondition)issuesCondition, null, null, (List)ImmutableList.of((Object)"archiveddate DESC"), EntityFindOptions.findOptions().fetchSize(maxResults));
    }

    private EntityCondition getQueryConditions(ArchiveQuery query, EntityCondition issuesCondition, boolean skipArchived) {
        Optional<Project> project = query.getProject();
        Optional<ApplicationUser> reporter = query.getReporter();
        Optional<ApplicationUser> archivedBy = query.getArchivedBy();
        Optional<Timestamp> archivedBefore = query.getArchivedBefore();
        Optional<Timestamp> archivedAfter = query.getArchivedAfter();
        Optional<IssueType> issueType = query.getIssueType();
        if (project.isPresent()) {
            issuesCondition = new EntityConditionList((List)ImmutableList.of((Object)issuesCondition, (Object)new EntityExpr("project", EntityOperator.EQUALS, (Object)project.get().getId())), EntityOperator.AND);
        }
        if (reporter.isPresent()) {
            issuesCondition = new EntityConditionList((List)ImmutableList.of((Object)issuesCondition, (Object)new EntityExpr("reporter", EntityOperator.EQUALS, (Object)reporter.get().getKey())), EntityOperator.AND);
        }
        if (issueType.isPresent()) {
            issuesCondition = new EntityConditionList((List)ImmutableList.of((Object)issuesCondition, (Object)new EntityExpr("type", EntityOperator.EQUALS, (Object)issueType.get().getId())), EntityOperator.AND);
        }
        if (!skipArchived) {
            if (archivedBy.isPresent()) {
                issuesCondition = new EntityConditionList((List)ImmutableList.of((Object)issuesCondition, (Object)new EntityExpr("archivedby", EntityOperator.EQUALS, (Object)archivedBy.get().getKey())), EntityOperator.AND);
            }
            if (archivedAfter.isPresent()) {
                issuesCondition = new EntityConditionList((List)ImmutableList.of((Object)issuesCondition, (Object)new EntityExpr("archiveddate", EntityOperator.GREATER_THAN_EQUAL_TO, (Object)archivedAfter.get())), EntityOperator.AND);
            }
            if (archivedBefore.isPresent()) {
                issuesCondition = new EntityConditionList((List)ImmutableList.of((Object)issuesCondition, (Object)new EntityExpr("archiveddate", EntityOperator.LESS_THAN_EQUAL_TO, (Object)archivedBefore.get())), EntityOperator.AND);
            }
        }
        return issuesCondition;
    }

    private Stream<GenericValue> iterateStream(OfBizListIterator ofBizIterator, AtomicInteger currentMax) {
        Iterator iterator = ofBizIterator.iterator();
        Stream stream = StreamSupport.stream(Spliterators.spliterator(iterator, (long)currentMax.get(), 16), false);
        return (Stream)stream.onClose(() -> {
            ofBizIterator.close();
            log.debug("Closed ofbiz iterator");
        });
    }
}

