/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.archiving.query;

import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import java.sql.Timestamp;
import java.util.Optional;

public class ArchiveQuery {
    private final Project project;
    private final Timestamp archivedAfter;
    private final Timestamp archivedBefore;
    private final ApplicationUser archivedBy;
    private final ApplicationUser reporter;
    private final IssueType issueType;
    private final int maxResults;

    ArchiveQuery(Project project, Timestamp archivedAfter, Timestamp archivedBefore, ApplicationUser archivedBy, ApplicationUser reporter, IssueType issueType, int maxResults) {
        this.project = project;
        this.archivedAfter = archivedAfter;
        this.archivedBefore = archivedBefore;
        this.archivedBy = archivedBy;
        this.reporter = reporter;
        this.issueType = issueType;
        this.maxResults = maxResults;
    }

    public Optional<Project> getProject() {
        return Optional.ofNullable(this.project);
    }

    public Optional<ApplicationUser> getReporter() {
        return Optional.ofNullable(this.reporter);
    }

    public Optional<IssueType> getIssueType() {
        return Optional.ofNullable(this.issueType);
    }

    public Optional<ApplicationUser> getArchivedBy() {
        return Optional.ofNullable(this.archivedBy);
    }

    public Optional<Timestamp> getArchivedBefore() {
        return Optional.ofNullable(this.archivedBefore);
    }

    public Optional<Timestamp> getArchivedAfter() {
        return Optional.ofNullable(this.archivedAfter);
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public String toString() {
        return "ArchiveQuery{project=" + this.project + ", archivedAfter=" + this.archivedAfter + ", archivedBefore=" + this.archivedBefore + ", archivedBy=" + this.archivedBy + ", reporter=" + this.reporter + ", issueType=" + this.issueType + ", maxResults=" + this.maxResults + '}';
    }

    public static class Builder {
        private Project project;
        private Timestamp archivedAfter;
        private Timestamp archivedBefore;
        private ApplicationUser archivedBy;
        private ApplicationUser reporter;
        private IssueType issueType;
        private int maxResults = Integer.MAX_VALUE;

        public Builder project(Project project) {
            this.project = project;
            return this;
        }

        public Builder archivedAfter(Timestamp archivedAfter) {
            this.archivedAfter = archivedAfter;
            return this;
        }

        public Builder archivedBefore(Timestamp archivedBefore) {
            this.archivedBefore = archivedBefore;
            return this;
        }

        public Builder archivedBy(ApplicationUser archivedBy) {
            this.archivedBy = archivedBy;
            return this;
        }

        public Builder reporter(ApplicationUser reporter) {
            this.reporter = reporter;
            return this;
        }

        public Builder issueType(IssueType issueType) {
            this.issueType = issueType;
            return this;
        }

        public Builder maxResults(int maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public ArchiveQuery build() {
            return new ArchiveQuery(this.project, this.archivedAfter, this.archivedBefore, this.archivedBy, this.reporter, this.issueType, this.maxResults);
        }
    }
}

