/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.archiving;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.ArchiveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.archiving.ArchivedIssueService;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.archiving.ArchivingLicenseCheck;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;

public class DefaultArchivedIssueService
implements ArchivedIssueService {
    private final GlobalPermissionManager globalPermissionManager;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final IssueService issueService;
    private final ArchivingLicenseCheck archivingLicenseCheck;
    private final I18nHelper.BeanFactory i18nFactory;
    private final IssueManager issueManager;

    public DefaultArchivedIssueService(GlobalPermissionManager globalPermissionManager, PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext, IssueService issueService, ArchivingLicenseCheck archivingLicenseCheck, I18nHelper.BeanFactory i18nFactory, IssueManager issueManager) {
        this.globalPermissionManager = globalPermissionManager;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.issueService = issueService;
        this.archivingLicenseCheck = archivingLicenseCheck;
        this.i18nFactory = i18nFactory;
        this.issueManager = issueManager;
    }

    @Override
    public ArchivedIssueService.ArchivingResult archiveIssue(ArchivedIssueService.ValidationResult validation) {
        return this.updateIssue(validation, true);
    }

    @Override
    public ArchivedIssueService.ValidationResult validateArchiveIssue(ApplicationUser user, String issueKey) {
        IssueService.IssueResult issueResult = this.issueService.getIssue(user, issueKey);
        if (!issueResult.isValid() || issueResult.getIssue() == null) {
            return new ArchivedIssueService.ValidationResult(ErrorCollections.copyOf((ErrorCollection)issueResult.getErrorCollection()), issueKey);
        }
        if (!this.isArchivingAllowed()) {
            return this.createErrorResult((Issue)issueResult.getIssue(), "admin.errors.archivedissue.error.feature.not.active", ErrorCollection.Reason.FORBIDDEN);
        }
        if (this.canIssueOperation(user, (Issue)issueResult.getIssue(), ProjectPermissions.ARCHIVE_ISSUES)) {
            return new ArchivedIssueService.ValidationResult(ErrorCollections.create((String)this.i18nFactory.getInstance(this.jiraAuthenticationContext.getLoggedInUser()).getText("admin.errors.archivedissue.error.no.issue.archive.permission"), (ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN), issueKey);
        }
        if (issueResult.getIssue().isArchived()) {
            return this.createErrorResult((Issue)issueResult.getIssue(), "admin.errors.archivedissue.error.archiving.archived", ErrorCollection.Reason.FORBIDDEN);
        }
        if (issueResult.getIssue().isSubTask()) {
            return this.createErrorResult((Issue)issueResult.getIssue(), "admin.errors.archivedissue.error.archiving.subtask", ErrorCollection.Reason.FORBIDDEN);
        }
        return new ArchivedIssueService.ValidationResult(ErrorCollections.empty(), (Issue)issueResult.getIssue(), user);
    }

    @Override
    public ArchivedIssueService.ArchivingResult restoreIssue(ArchivedIssueService.ValidationResult validation) {
        return this.updateIssue(validation, false);
    }

    private ArchivedIssueService.ArchivingResult updateIssue(ArchivedIssueService.ValidationResult validation, boolean archived) {
        Issue issue = validation.getIssue();
        if (!this.isArchivingAllowed()) {
            return this.createErrorResult(issue, "admin.errors.archivedissue.error.feature.not.active", ErrorCollection.Reason.FORBIDDEN);
        }
        try {
            Issue updatedIssue = archived ? this.issueManager.archiveIssue(validation.getUser(), issue, EventDispatchOption.ISSUE_ARCHIVED, true) : this.issueManager.restoreIssue(validation.getUser(), issue, EventDispatchOption.ISSUE_RESTORED, true);
            return new ArchivedIssueService.ArchivingResult((ErrorCollection)new SimpleErrorCollection(), updatedIssue);
        }
        catch (ArchiveException ex) {
            return this.createErrorResult(issue, ex.getMessage(), ErrorCollection.Reason.FORBIDDEN);
        }
    }

    @Override
    public ArchivedIssueService.ValidationResult validateRestoreIssue(ApplicationUser user, String issueKey) {
        IssueService.IssueResult issueResult = this.issueService.getIssue(user, issueKey);
        if (!issueResult.isValid() || issueResult.getIssue() == null) {
            return new ArchivedIssueService.ValidationResult(ErrorCollections.copyOf((ErrorCollection)issueResult.getErrorCollection()), issueKey);
        }
        if (!this.isArchivingAllowed()) {
            return this.createErrorResult((Issue)issueResult.getIssue(), "admin.errors.archivedissue.error.feature.not.active", ErrorCollection.Reason.FORBIDDEN);
        }
        if (this.canIssueOperation(user, (Issue)issueResult.getIssue(), ProjectPermissions.RESTORE_ISSUES)) {
            return new ArchivedIssueService.ValidationResult(ErrorCollections.create((String)this.i18nFactory.getInstance(this.jiraAuthenticationContext.getLoggedInUser()).getText("admin.errors.archivedissue.error.no.issue.restore.permission"), (ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN), issueKey);
        }
        if (issueResult.isValid() && issueResult.getIssue() != null) {
            if (!issueResult.getIssue().isArchived()) {
                return this.createErrorResult((Issue)issueResult.getIssue(), "admin.errors.archivedissue.error.archiving.restored", ErrorCollection.Reason.FORBIDDEN);
            }
            if (issueResult.getIssue().isSubTask()) {
                return this.createErrorResult((Issue)issueResult.getIssue(), "admin.errors.archivedissue.error.restoring.subtask", ErrorCollection.Reason.FORBIDDEN);
            }
            if (issueResult.getIssue().getProjectObject().isArchived()) {
                return this.createErrorResult((Issue)issueResult.getIssue(), "admin.errors.archivedissue.error.archiving.project", ErrorCollection.Reason.FORBIDDEN);
            }
        }
        return new ArchivedIssueService.ValidationResult(ErrorCollections.empty(), (Issue)issueResult.getIssue(), user);
    }

    private boolean canIssueOperation(ApplicationUser user, Issue issue, ProjectPermissionKey permission) {
        return !this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user) && !this.permissionManager.hasPermission(permission, issue, user);
    }

    public boolean isArchivingAllowed() {
        return this.archivingLicenseCheck.isLicensedForIssueArchiving();
    }

    private ArchivedIssueService.ArchivingResult createErrorResult(Issue issue, String errorKey, ErrorCollection.Reason failedReason) {
        SimpleErrorCollection simpleErrorCollection = new SimpleErrorCollection();
        simpleErrorCollection.addErrorMessage(this.i18nFactory.getInstance(this.jiraAuthenticationContext.getLoggedInUser()).getText(errorKey), failedReason);
        return new ArchivedIssueService.ArchivingResult((ErrorCollection)simpleErrorCollection, issue);
    }
}

