/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.archiving;

import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.database.DatabaseUtil;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.archiving.ArchivedIssueSearchService;
import com.atlassian.jira.issue.archiving.query.ArchiveQuery;
import com.atlassian.jira.issue.archiving.query.ArchiveQueryUtil;
import com.atlassian.jira.issue.archiving.query.ArchivedIssue;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.archiving.ArchivedProjectManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Either;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;

public class DefaultArchivedIssueSearchService
implements ArchivedIssueSearchService {
    @Inject
    private final IssueFactory issueFactory;
    @Inject
    private final OfBizDelegator ofBizDelegator;
    private final ArchiveQueryUtil archiveQueryUtil;
    private final GlobalPermissionManager globalPermissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectService projectService;
    private final I18nHelper.BeanFactory i18nFactory;
    private final ConstantsManager constantsManager;
    private static final Pattern PROJECT_ID_PATTERN = Pattern.compile("^[1-9]\\d{0,17}$");

    public DefaultArchivedIssueSearchService(IssueFactory issueFactory, ProjectManager projectManager, OfBizDelegator ofBizDelegator, GlobalPermissionManager globalPermissionManager, JiraAuthenticationContext authenticationContext, ProjectService projectService, I18nHelper.BeanFactory i18nFactory, ConstantsManager constantsManager) {
        this.issueFactory = issueFactory;
        this.ofBizDelegator = ofBizDelegator;
        this.globalPermissionManager = globalPermissionManager;
        this.authenticationContext = authenticationContext;
        this.projectService = projectService;
        this.i18nFactory = i18nFactory;
        this.constantsManager = constantsManager;
        this.archiveQueryUtil = new ArchiveQueryUtil(ofBizDelegator, projectManager, (ArchivedProjectManager)ComponentAccessor.getComponent(ArchivedProjectManager.class), issueFactory);
    }

    @Override
    public List<Issue> getArchivedIssuesMatchingTypesInProjects(List<Long> projectIds, List<String> issueTypeIds) {
        EntityExpr whereMatchProject = new EntityExpr("project", EntityOperator.IN, projectIds);
        EntityExpr whereMatchIssueType = new EntityExpr("type", EntityOperator.IN, issueTypeIds);
        EntityExpr whereArchived = new EntityExpr("archived", EntityOperator.EQUALS, (Object)DatabaseUtil.booleanToChar1(true));
        EntityConditionList conditions = new EntityConditionList((List)ImmutableList.of((Object)whereArchived, (Object)whereMatchProject, (Object)whereMatchIssueType), EntityOperator.AND);
        return this.issueFactory.getIssues((Collection)this.ofBizDelegator.findListIteratorByCondition("Issue", (EntityCondition)conditions).getCompleteList());
    }

    @Override
    public ArchivedIssueSearchService.ValidationResult validateSearch(ArchivedIssueSearchService.ArchiveSearchRequest request) {
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, this.authenticationContext.getLoggedInUser())) {
            return this.createErrorResult("admin.errors.archivedissue.error.system.admin.required", ErrorCollection.Reason.FORBIDDEN);
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{request.projectKeyOrId}) && !this.getProjectForAction(this.authenticationContext.getLoggedInUser(), DefaultArchivedIssueSearchService.parse(request.projectKeyOrId), ProjectAction.VIEW_ARCHIVED_PROJECT).isValid()) {
            return this.createErrorResult("admin.errors.archivedissue.error.project.not.found", ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{request.issueType}) && this.constantsManager.getIssueType(request.issueType) == null) {
            return this.createErrorResult("admin.errors.archivedissue.error.issue.type.not.found", ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{request.archivedBy}) && ApplicationUsers.byKey(request.archivedBy) == null) {
            return this.createErrorResult("admin.errors.archivedissue.error.archived.by.not.found", ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{request.reporter}) && ApplicationUsers.byKey(request.reporter) == null) {
            return this.createErrorResult("admin.errors.archivedissue.error.reporter.not.found", ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (request.archivedBefore != null && request.archivedAfter != null && request.archivedBefore < request.archivedAfter) {
            return this.createErrorResult("admin.errors.archivedissue.error.invalid.date.range", ErrorCollection.Reason.VALIDATION_FAILED);
        }
        ArchiveQuery.Builder builder = new ArchiveQuery.Builder();
        if (request.maxResults != null) {
            builder.maxResults(request.maxResults);
        }
        ArchiveQuery query = builder.project(StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{request.projectKeyOrId}) ? this.getProjectForAction(this.authenticationContext.getLoggedInUser(), DefaultArchivedIssueSearchService.parse(request.projectKeyOrId), ProjectAction.VIEW_ARCHIVED_PROJECT).get() : null).reporter(ApplicationUsers.byKey(request.reporter)).issueType(this.constantsManager.getIssueType(request.issueType)).archivedBy(ApplicationUsers.byKey(request.archivedBy)).archivedBefore(request.archivedBefore != null ? new Timestamp(request.archivedBefore) : null).archivedAfter(request.archivedAfter != null ? new Timestamp(request.archivedAfter) : null).build();
        return new ArchivedIssueSearchService.ValidationResult(query);
    }

    @Override
    public Stream<ArchivedIssue> search(ArchivedIssueSearchService.ValidationResult validationResult) {
        Preconditions.checkNotNull((Object)((Object)validationResult));
        Preconditions.checkArgument((boolean)validationResult.isValid());
        Preconditions.checkNotNull((Object)validationResult.getQuery());
        return this.archiveQueryUtil.queryArchivedIssues(validationResult.getQuery());
    }

    public static Either<Long, String> parse(String projectKeyOrId) {
        return DefaultArchivedIssueSearchService.isProjectId(projectKeyOrId) ? Either.left((Object)Long.parseLong(projectKeyOrId)) : Either.right((Object)projectKeyOrId);
    }

    private static boolean isProjectId(String projectIdOrKey) {
        return PROJECT_ID_PATTERN.matcher(projectIdOrKey).matches();
    }

    private ProjectService.GetProjectResult getProjectForAction(ApplicationUser user, Either<Long, String> projectKeyOrId, ProjectAction projectAction) {
        return (ProjectService.GetProjectResult)projectKeyOrId.fold(id -> this.projectService.getProjectByIdForAction(user, id, projectAction), key -> this.projectService.getProjectByKeyForAction(user, key, projectAction));
    }

    private ArchivedIssueSearchService.ValidationResult createErrorResult(String errorKey, ErrorCollection.Reason failedReason) {
        SimpleErrorCollection simpleErrorCollection = new SimpleErrorCollection();
        simpleErrorCollection.addErrorMessage(this.i18nFactory.getInstance(this.authenticationContext.getLoggedInUser()).getText(errorKey), failedReason);
        return new ArchivedIssueSearchService.ValidationResult((ErrorCollection)simpleErrorCollection);
    }
}

