/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.archiving;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.archiving.query.ArchiveQuery;
import com.atlassian.jira.issue.archiving.query.ArchivedIssue;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@ExperimentalApi
public interface ArchivedIssueSearchService {
    public List<Issue> getArchivedIssuesMatchingTypesInProjects(List<Long> var1, List<String> var2);

    public ValidationResult validateSearch(ArchiveSearchRequest var1);

    public Stream<ArchivedIssue> search(ValidationResult var1);

    public static class ArchiveSearchRequest {
        Integer maxResults;
        String projectKeyOrId;
        String reporter;
        String issueType;
        String archivedBy;
        Long archivedBefore;
        Long archivedAfter;

        public ArchiveSearchRequest setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public ArchiveSearchRequest setProjectKeyOrId(String projectKeyOrId) {
            this.projectKeyOrId = projectKeyOrId;
            return this;
        }

        public ArchiveSearchRequest setReporter(String reporter) {
            this.reporter = reporter;
            return this;
        }

        public ArchiveSearchRequest setIssueType(String issueType) {
            this.issueType = issueType;
            return this;
        }

        public ArchiveSearchRequest setArchivedBy(String archivedBy) {
            this.archivedBy = archivedBy;
            return this;
        }

        public ArchiveSearchRequest setArchivedBefore(Long archivedBefore) {
            this.archivedBefore = archivedBefore;
            return this;
        }

        public ArchiveSearchRequest setArchivedAfter(Long archivedAfter) {
            this.archivedAfter = archivedAfter;
            return this;
        }
    }

    public static final class ValidationResult
    extends ServiceResultImpl {
        private final ArchiveQuery query;

        protected ValidationResult(ArchiveQuery query) {
            super(ErrorCollections.empty());
            this.query = query;
        }

        protected ValidationResult(@Nonnull ErrorCollection errorCollection) {
            super(errorCollection);
            this.query = null;
        }

        public boolean isValid() {
            return super.isValid() && this.query != null;
        }

        public ArchiveQuery getQuery() {
            return this.query;
        }
    }
}

