/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueTextFieldCharacterLengthValidator;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.TextCustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.TextFieldCharacterLengthValidator;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.Predicates;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Option;
import io.atlassian.util.concurrent.LazyReference;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class DefaultIssueTextFieldCharacterLengthValidator
implements IssueTextFieldCharacterLengthValidator {
    private final TextFieldCharacterLengthValidator textFieldCharacterLengthValidator;
    private final LazyReference<CustomFieldManager> customFieldManagerLazyReference = new LazyReference<CustomFieldManager>(){

        protected CustomFieldManager create() throws Exception {
            return ComponentAccessor.getCustomFieldManager();
        }
    };

    public DefaultIssueTextFieldCharacterLengthValidator(TextFieldCharacterLengthValidator textFieldCharacterLengthValidator) {
        this.textFieldCharacterLengthValidator = textFieldCharacterLengthValidator;
    }

    @Override
    @Nonnull
    public IssueTextFieldCharacterLengthValidator.ValidationResult validateAllFields(@Nonnull Issue issue) {
        return this.validateFields(issue, (Option<Set<String>>)Option.none());
    }

    @Override
    @Nonnull
    public IssueTextFieldCharacterLengthValidator.ValidationResult validateModifiedFields(@Nonnull MutableIssue issue) {
        return this.validateFields((Issue)issue, (Option<Set<String>>)Option.some(issue.getModifiedFields().keySet()));
    }

    private IssueTextFieldCharacterLengthValidator.ValidationResult validateFields(@Nonnull Issue issue, @Nonnull Option<Set<String>> fieldsToValidate) {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        this.validateSystemFields(issue, (ImmutableSet.Builder<String>)builder, fieldsToValidate.isDefined() ? this.modifiedOnly((Set)fieldsToValidate.get()) : Predicates.truePredicate());
        if (fieldsToValidate.isDefined()) {
            this.validateModifiedCustomFields(issue, (ImmutableSet.Builder<String>)builder, (Set)fieldsToValidate.get());
        } else {
            this.validateAllCustomFields(issue, (ImmutableSet.Builder<String>)builder);
        }
        return new ValidationResultImpl((ImmutableSet<String>)builder.build(), this.textFieldCharacterLengthValidator.getMaximumNumberOfCharacters());
    }

    private Predicate<String> modifiedOnly(final Set<String> fieldsToValidate) {
        return new Predicate<String>(){

            public boolean evaluate(String fieldId) {
                return fieldsToValidate.contains(fieldId);
            }
        };
    }

    private void validateSystemFields(Issue issue, ImmutableSet.Builder<String> builder, Predicate<String> shouldValidate) {
        if (shouldValidate.evaluate((Object)"description") && this.textFieldCharacterLengthValidator.isTextTooLong(issue.getDescription())) {
            builder.add((Object)"description");
        }
        if (shouldValidate.evaluate((Object)"environment") && this.textFieldCharacterLengthValidator.isTextTooLong(issue.getEnvironment())) {
            builder.add((Object)"environment");
        }
    }

    private void validateAllCustomFields(Issue issue, ImmutableSet.Builder<String> builder) {
        List customFieldObjects = ((CustomFieldManager)this.customFieldManagerLazyReference.get()).getCustomFieldObjects(issue);
        for (CustomField cf : customFieldObjects) {
            this.validateCustomField(issue, builder, cf);
        }
    }

    private void validateCustomField(Issue issue, ImmutableSet.Builder<String> builder, CustomField cf) {
        Object customFieldValue;
        if (cf.getCustomFieldType() instanceof TextCustomFieldType && (customFieldValue = issue.getCustomFieldValue(cf)) instanceof String && this.textFieldCharacterLengthValidator.isTextTooLong((String)customFieldValue)) {
            builder.add((Object)cf.getId());
        }
    }

    private void validateModifiedCustomFields(Issue issue, ImmutableSet.Builder<String> builder, Set<String> fieldsToValidate) {
        for (String fieldId : fieldsToValidate) {
            CustomField cf;
            if ("description".equals(fieldId) || "environment".equals(fieldId) || (cf = ((CustomFieldManager)this.customFieldManagerLazyReference.get()).getCustomFieldObject(fieldId)) == null) continue;
            this.validateCustomField(issue, builder, cf);
        }
    }

    class ValidationResultImpl
    implements IssueTextFieldCharacterLengthValidator.ValidationResult {
        private final ImmutableSet<String> invalidFieldIds;
        private final long maximumNumberOfCharacters;

        ValidationResultImpl(ImmutableSet<String> invalidFieldIds, long maximumNumberOfCharacters) {
            this.invalidFieldIds = invalidFieldIds;
            this.maximumNumberOfCharacters = maximumNumberOfCharacters;
        }

        @Override
        public boolean isValid() {
            return this.invalidFieldIds.isEmpty();
        }

        @Override
        public long getMaximumNumberOfCharacters() {
            return this.maximumNumberOfCharacters;
        }

        @Override
        @Nonnull
        public Set<String> getInvalidFieldIds() {
            return this.invalidFieldIds;
        }
    }
}

