/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.DocumentIssueImpl;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueImpl;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.label.LabelManager;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.jql.util.JqlLocalDateSupport;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.archiving.ArchivedProjectManager;
import com.atlassian.jira.project.archiving.ArchivingLicenseCheck;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.util.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.document.Document;
import org.ofbiz.core.entity.GenericValue;

public class DefaultIssueFactory
implements IssueFactory {
    private final IssueManager issueManager;
    private final ProjectManager projectManager;
    private final ArchivedProjectManager archivedProjectManager;
    private final VersionManager versionManager;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final ConstantsManager constantsManager;
    private final SubTaskManager subTaskManager;
    private final FieldManager fieldManager;
    private final AttachmentManager attachmentManager;
    private final ProjectFactory projectFactory;
    private final LabelManager labelManager;
    private final ProjectComponentManager projectComponentManager;
    private final UserManager userManager;
    private final JqlLocalDateSupport jqlLocalDateSupport;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ArchivingLicenseCheck archivingLicenseCheck;

    public DefaultIssueFactory(IssueManager issueManager, ProjectManager projectManager, ArchivedProjectManager archivedProjectManager, VersionManager versionManager, IssueSecurityLevelManager issueSecurityLevelManager, ConstantsManager constantsManager, SubTaskManager subTaskManager, FieldManager fieldManager, AttachmentManager attachmentManager, ProjectFactory projectFactory, LabelManager labelManager, ProjectComponentManager projectComponentManager, UserManager userManager, JqlLocalDateSupport jqlLocalDateSupport, JiraAuthenticationContext jiraAuthenticationContext, ArchivingLicenseCheck archivingLicenseCheck) {
        this.issueManager = issueManager;
        this.projectManager = projectManager;
        this.archivedProjectManager = archivedProjectManager;
        this.versionManager = versionManager;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.constantsManager = constantsManager;
        this.subTaskManager = subTaskManager;
        this.fieldManager = fieldManager;
        this.attachmentManager = attachmentManager;
        this.projectFactory = projectFactory;
        this.labelManager = labelManager;
        this.projectComponentManager = projectComponentManager;
        this.userManager = userManager;
        this.jqlLocalDateSupport = jqlLocalDateSupport;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.archivingLicenseCheck = archivingLicenseCheck;
    }

    public MutableIssue getIssue() {
        return this.getIssue((GenericValue)null);
    }

    public MutableIssue getIssue(GenericValue issueGV) {
        return new IssueImpl(issueGV, this.issueManager, this.projectManager, this.archivedProjectManager, this.versionManager, this.issueSecurityLevelManager, this.constantsManager, this.subTaskManager, this.attachmentManager, this.labelManager, this.projectComponentManager, this.userManager, this.jiraAuthenticationContext, this.archivingLicenseCheck);
    }

    public MutableIssue getIssueOrNull(GenericValue issueGV) {
        if (issueGV == null) {
            return null;
        }
        return this.getIssue(issueGV);
    }

    public MutableIssue cloneIssue(Issue issue) {
        return new IssueImpl(issue, this.issueManager, this.projectManager, this.archivedProjectManager, this.versionManager, this.issueSecurityLevelManager, this.constantsManager, this.subTaskManager, this.attachmentManager, this.labelManager, this.projectComponentManager, this.userManager, this.jiraAuthenticationContext, this.archivingLicenseCheck);
    }

    public MutableIssue cloneIssueWithAllFields(Issue issue) {
        IssueImpl ret = new IssueImpl(issue, this.issueManager, this.projectManager, this.archivedProjectManager, this.versionManager, this.issueSecurityLevelManager, this.constantsManager, this.subTaskManager, this.attachmentManager, this.labelManager, this.projectComponentManager, this.userManager, this.jiraAuthenticationContext, this.archivingLicenseCheck);
        ComponentAccessor.getCustomFieldManager().getCustomFieldObjects(issue).forEach(cf -> ret.setCustomFieldValue((CustomField)cf, issue.getCustomFieldValue(cf)));
        return ret;
    }

    public List<Issue> getIssues(Collection<GenericValue> issueGVs) {
        ArrayList<Issue> issues = new ArrayList<Issue>(issueGVs.size());
        for (GenericValue issue : issueGVs) {
            issues.add((Issue)this.getIssue(issue));
        }
        return issues;
    }

    public Issue getIssue(Document issueDocument) {
        return new DocumentIssueImpl(issueDocument, this.constantsManager, this.fieldManager, this.issueManager, this, this.attachmentManager, this.projectFactory, this.jqlLocalDateSupport);
    }

    public MutableIssue cloneIssueNoParent(Issue issue) {
        IssueImpl clonedIssue = new IssueImpl((GenericValue)issue.getGenericValue().clone(), this.issueManager, this.projectManager, this.archivedProjectManager, this.versionManager, this.issueSecurityLevelManager, this.constantsManager, this.subTaskManager, this.attachmentManager, this.labelManager, this.projectComponentManager, this.userManager, this.jiraAuthenticationContext, this.archivingLicenseCheck);
        clonedIssue.hasNoParentId = true;
        return clonedIssue;
    }
}

