/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation.external;

import com.atlassian.instrumentation.CachedExternalValue;
import com.atlassian.instrumentation.ExternalValue;
import com.atlassian.instrumentation.Instrument;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.instrumentation.util.InstrumentFactory;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.TimeUnit;

class ThreadExternalGauges {
    ThreadExternalGauges() {
        Instrumentation.putInstrument((Instrument)InstrumentFactory.newExternalGauge(InstrumentationName.THREAD_TOTAL_COUNT, new ThreadMXExternalValue(){

            public long getValue() {
                return this.getMxBean().getThreadCount();
            }
        }));
        Instrumentation.putInstrument((Instrument)InstrumentFactory.newExternalGauge(InstrumentationName.THREAD_DAEMON_COUNT, new ThreadMXExternalValue(){

            public long getValue() {
                return this.getMxBean().getDaemonThreadCount();
            }
        }));
        Instrumentation.putInstrument((Instrument)InstrumentFactory.newExternalGauge(InstrumentationName.THREAD_NONDAEMON_COUNT, new ThreadMXExternalValue(){

            public long getValue() {
                ThreadMXBean threadMXBean = this.getMxBean();
                return threadMXBean.getThreadCount() - threadMXBean.getDaemonThreadCount();
            }
        }));
        Instrumentation.putInstrument((Instrument)InstrumentFactory.newExternalGauge(InstrumentationName.THREAD_PEAK_COUNT, new ThreadMXExternalValue(){

            public long getValue() {
                return this.getMxBean().getPeakThreadCount();
            }
        }));
        Instrumentation.putInstrument((Instrument)InstrumentFactory.newExternalGauge(InstrumentationName.THREAD_EVER_COUNT, new ThreadMXExternalValue(){

            public long getValue() {
                return this.getMxBean().getTotalStartedThreadCount();
            }
        }));
        Instrumentation.putInstrument((Instrument)InstrumentFactory.newExternalCounter(InstrumentationName.THREAD_CPU_TIME, (ExternalValue)new CachedThreadMXExternalValue(){

            protected long computeValue() {
                return this.safelyGetValue((threadId, mxBean) -> mxBean.getThreadCpuTime(threadId));
            }
        }));
        Instrumentation.putInstrument((Instrument)InstrumentFactory.newExternalCounter(InstrumentationName.THREAD_CPU_USER_TIME, (ExternalValue)new CachedThreadMXExternalValue(){

            protected long computeValue() {
                return this.safelyGetValue((threadId, mxBean) -> mxBean.getThreadUserTime(threadId));
            }
        }));
        Instrumentation.putInstrument((Instrument)InstrumentFactory.newExternalCounter(InstrumentationName.THREAD_CPU_BLOCK_TIME, (ExternalValue)new CachedThreadMXExternalValue(){

            protected long computeValue() {
                if (this.isThreadContentionAvailable()) {
                    return this.safelyGetValue((threadId, mxBean) -> mxBean.getThreadInfo(threadId).getBlockedTime());
                }
                return 0L;
            }
        }));
        Instrumentation.putInstrument((Instrument)InstrumentFactory.newExternalCounter(InstrumentationName.THREAD_CPU_BLOCK_COUNT, (ExternalValue)new CachedThreadMXExternalValue(){

            protected long computeValue() {
                if (this.isThreadContentionAvailable()) {
                    return this.safelyGetValue((threadId, mxBean) -> mxBean.getThreadInfo(threadId).getBlockedCount());
                }
                return 0L;
            }
        }));
        Instrumentation.putInstrument((Instrument)InstrumentFactory.newExternalCounter(InstrumentationName.THREAD_CPU_WAIT_TIME, (ExternalValue)new CachedThreadMXExternalValue(){

            protected long computeValue() {
                if (this.isThreadContentionAvailable()) {
                    return this.safelyGetValue((threadId, mxBean) -> mxBean.getThreadInfo(threadId).getWaitedTime());
                }
                return 0L;
            }
        }));
        Instrumentation.putInstrument((Instrument)InstrumentFactory.newExternalCounter(InstrumentationName.THREAD_CPU_WAIT_COUNT, (ExternalValue)new CachedThreadMXExternalValue(){

            protected long computeValue() {
                if (this.isThreadContentionAvailable()) {
                    return this.safelyGetValue((threadId, mxBean) -> mxBean.getThreadInfo(threadId).getWaitedCount());
                }
                return 0L;
            }
        }));
    }

    private static abstract class CachedThreadMXExternalValue
    extends CachedExternalValue {
        CachedThreadMXExternalValue() {
            super(2L, TimeUnit.MINUTES);
        }

        ThreadMXBean getMxBean() {
            return ManagementFactory.getThreadMXBean();
        }

        long safelyGetValue(CalculateThreadValue calculateThreadValue) {
            try {
                long value = 0L;
                for (long threadId : this.getMxBean().getAllThreadIds()) {
                    value += calculateThreadValue.calculate(threadId, this.getMxBean());
                }
                return Math.max(0L, value);
            }
            catch (Exception e) {
                return 0L;
            }
        }

        boolean isThreadContentionAvailable() {
            return this.getMxBean().isThreadContentionMonitoringSupported() && this.getMxBean().isThreadContentionMonitoringEnabled();
        }

        static interface CalculateThreadValue {
            public long calculate(long var1, ThreadMXBean var3);
        }
    }

    private static abstract class ThreadMXExternalValue
    implements ExternalValue {
        private ThreadMXExternalValue() {
        }

        ThreadMXBean getMxBean() {
            return ManagementFactory.getThreadMXBean();
        }
    }
}

