/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation;

import com.atlassian.instrumentation.Instrument;
import com.atlassian.jira.util.Supplier;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.stream.Collectors;

public class GenericInstrument
implements Instrument {
    private final String name;
    private final ImmutableMap<String, Supplier<Object>> suppliers;
    private final long value;

    public GenericInstrument(String name, Map<String, Supplier<Object>> suppliers) {
        this(name, suppliers, 0L);
    }

    public GenericInstrument(String name, Map<String, Supplier<Object>> suppliers, long value) {
        this.name = name;
        this.suppliers = ImmutableMap.copyOf(suppliers);
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public long getValue() {
        return this.value;
    }

    public int compareTo(Instrument o) {
        return 0;
    }

    public Map<String, Supplier<Object>> snapshot() {
        return this.suppliers.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Supplier)e.getValue()));
    }
}

