/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instance;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.Internal;
import com.atlassian.jira.instance.InstanceState;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.web.startup.StartupPageSupport;
import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.setup.SetupConfig;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ExperimentalApi
@ParametersAreNonnullByDefault
@Internal
public class InstanceStateProvider {
    private final BuildUtilsInfo buildUtilsInfo;
    private final SetupConfig setupConfig;
    private final Supplier<Boolean> instanceHasLaunched;

    public InstanceStateProvider(BuildUtilsInfo buildUtilsInfo) {
        this(buildUtilsInfo, StartupPageSupport::isLaunched, Johnson.getConfig().getSetupConfig());
    }

    @VisibleForTesting
    InstanceStateProvider(BuildUtilsInfo buildUtilsInfo, Supplier<Boolean> instanceHasLaunched, SetupConfig setupConfig) {
        this.buildUtilsInfo = Objects.requireNonNull(buildUtilsInfo);
        this.instanceHasLaunched = Objects.requireNonNull(instanceHasLaunched);
        this.setupConfig = Objects.requireNonNull(setupConfig);
    }

    @Nonnull
    public InstanceState currentState() {
        return (InstanceState)((Object)this.isInstalling().orElse(this::isUpgradeRequired).orElse(this::isRunning).getOrElse((Object)InstanceState.RESTARTING));
    }

    @Nonnull
    private Option<InstanceState> isRunning() {
        return this.instanceHasLaunched.get() != false ? Option.some((Object)((Object)InstanceState.RUNNING)) : Option.none();
    }

    @Nonnull
    private Option<InstanceState> isUpgradeRequired() {
        try {
            boolean isUpgrading = this.buildUtilsInfo.getDatabaseBuildNumber() > 0 && this.buildUtilsInfo.getApplicationBuildNumber() > this.buildUtilsInfo.getDatabaseBuildNumber();
            return isUpgrading ? Option.some((Object)((Object)InstanceState.UPGRADE_REQUIRED)) : Option.none();
        }
        catch (Exception e) {
            return Option.some((Object)((Object)InstanceState.UNKNOWN));
        }
    }

    @Nonnull
    private Option<InstanceState> isInstalling() {
        return this.setupConfig.isSetup() ? Option.none() : Option.some((Object)((Object)InstanceState.INSTALLING));
    }
}

