/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.summary;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.index.ManagedIndexSearcher;
import com.atlassian.jira.index.ha.IndexRecoveryManager;
import com.atlassian.jira.index.ha.OfBizNodeIndexCounterStore;
import com.atlassian.jira.index.ha.OfBizReplicatedIndexOperationStore;
import com.atlassian.jira.index.ha.ReplicatedIndexOperation;
import com.atlassian.jira.index.summary.IndexReplicationQueueEntry;
import com.atlassian.jira.index.summary.IndexReplicationQueueSummary;
import com.atlassian.jira.index.summary.IndexSummarizer;
import com.atlassian.jira.index.summary.IssueIndexSummary;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.project.archiving.ArchivedStatistics;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIndexSummarizer
implements IndexSummarizer {
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexSummarizer.class);
    private final IssueManager issueManager;
    private final ClusterManager clusterManager;
    private final IndexRecoveryManager indexRecoveryManager;
    private final IssueIndexManager issueIndexManager;
    private final ArchivedStatistics archivedStatistics;
    private final OfBizNodeIndexCounterStore ofBizNodeIndexCounterStore;
    private final OfBizReplicatedIndexOperationStore ofBizReplicatedIndexOperationStore;

    public DefaultIndexSummarizer(IssueManager issueManager, ClusterManager clusterManager, IndexRecoveryManager indexRecoveryManager, IssueIndexManager issueIndexManager, ArchivedStatistics archivedStatistics, OfBizNodeIndexCounterStore ofBizNodeIndexCounterStore, OfBizReplicatedIndexOperationStore ofBizReplicatedIndexOperationStore) {
        this.issueManager = issueManager;
        this.clusterManager = clusterManager;
        this.indexRecoveryManager = indexRecoveryManager;
        this.issueIndexManager = issueIndexManager;
        this.archivedStatistics = archivedStatistics;
        this.ofBizNodeIndexCounterStore = ofBizNodeIndexCounterStore;
        this.ofBizReplicatedIndexOperationStore = ofBizReplicatedIndexOperationStore;
    }

    public ServiceOutcome<IssueIndexSummary> summarizeIssueIndex() {
        long countInDatabase = this.issueManager.getIssueCount();
        long countInArchive = this.archivedStatistics.getTotalArchivedIssuesCount().intValue();
        try {
            long countInIndex = this.getCountOfIssuesInIndex();
            DateUtils.DateRange durationToRecover = this.indexRecoveryManager.getDurationToRecover();
            if (durationToRecover != null) {
                return ServiceOutcomeImpl.ok(new IssueIndexSummary(true, countInDatabase, countInIndex, countInArchive, durationToRecover.endDate.toInstant(), durationToRecover.startDate.toInstant()));
            }
            return ServiceOutcomeImpl.ok(new IssueIndexSummary(true, countInDatabase, countInIndex, countInArchive, null, null));
        }
        catch (Exception e) {
            log.error("Couldn't read the index", (Throwable)e);
            return ServiceOutcomeImpl.ok(IssueIndexSummary.notReadable());
        }
    }

    long getCountOfIssuesInIndex() {
        ManagedIndexSearcher issueSearcher = this.issueIndexManager.getIssueSearcher();
        return issueSearcher.getIndexReader().numDocs();
    }

    public ServiceOutcome<Map<String, IndexReplicationQueueSummary>> summarizeIndexReplicationQueues() {
        String currentNodeId = this.clusterManager.getNodeId();
        return ServiceOutcomeImpl.ok(this.summarizeIndexReplicationQueues(currentNodeId));
    }

    private Map<String, IndexReplicationQueueSummary> summarizeIndexReplicationQueues(String receivingNodeId) {
        if (this.clusterManager.isClustered()) {
            Set<Node> allNodes = this.clusterManager.getAllNodes();
            return allNodes.stream().filter(sendingNode -> !receivingNodeId.equals(sendingNode.getNodeId())).map(sendingNode -> this.summarizeIndexReplicationQueue(receivingNodeId, sendingNode.getNodeId()).orElse(null)).filter(Objects::nonNull).collect(Collectors.toMap(IndexReplicationQueueSummary::getSendingNodeId, Function.identity()));
        }
        return Collections.emptyMap();
    }

    private Optional<IndexReplicationQueueSummary> summarizeIndexReplicationQueue(String receivingNodeId, String sendingNodeId) {
        Long lastOperationInQueueId = this.ofBizReplicatedIndexOperationStore.getLatestOperation(sendingNodeId);
        if (lastOperationInQueueId == null) {
            return Optional.empty();
        }
        long lastConsumedOperationId = this.ofBizNodeIndexCounterStore.getIndexOperationCounterForNodeId(receivingNodeId, sendingNodeId);
        ReplicatedIndexOperation lastConsumedOperation = this.ofBizReplicatedIndexOperationStore.getOperation(lastConsumedOperationId);
        ReplicatedIndexOperation lastOperationInQueue = this.ofBizReplicatedIndexOperationStore.getOperation(lastOperationInQueueId);
        long replicationQueueSize = this.ofBizReplicatedIndexOperationStore.getIndexOperationsAfter(sendingNodeId, lastConsumedOperationId).size();
        return Optional.of(new IndexReplicationQueueSummary(sendingNodeId, lastConsumedOperation != null ? this.buildQueueEntry(lastConsumedOperation) : null, lastOperationInQueue != null ? this.buildQueueEntry(lastOperationInQueue) : null, Long.valueOf(replicationQueueSize)));
    }

    private IndexReplicationQueueEntry buildQueueEntry(ReplicatedIndexOperation replicatedIndexOperation) {
        return new IndexReplicationQueueEntry(Long.valueOf(replicatedIndexOperation.getId()), replicatedIndexOperation.getIndexTime().toInstant());
    }
}

