/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.util.IndexWriterConfiguration;
import com.atlassian.jira.index.Configuration;
import com.atlassian.jira.index.DefaultIndexEngine;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.MonitoringIndexWriter;
import com.atlassian.jira.index.UnmanagedIndexSearcher;
import com.atlassian.jira.index.Writer;
import com.atlassian.jira.util.LuceneDirectoryUtils;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriterWrapper
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(WriterWrapper.class);
    private final IndexWriter writer;
    private final Supplier<UnmanagedIndexSearcher> indexSearcherSupplier;
    private final DefaultIndexEngine.FlushPolicy flushPolicy;
    private final long commitFrequency;

    @Override
    public IndexWriter getLuceneWriter() {
        return this.writer;
    }

    @VisibleForTesting
    WriterWrapper(Supplier<IndexWriter> writerFactory, Supplier<UnmanagedIndexSearcher> indexSearcherSupplier, DefaultIndexEngine.FlushPolicy flushPolicy, long commitFrequency) {
        this.writer = (IndexWriter)writerFactory.get();
        this.indexSearcherSupplier = indexSearcherSupplier;
        this.flushPolicy = flushPolicy;
        this.commitFrequency = commitFrequency;
    }

    WriterWrapper(final @Nonnull Configuration configuration, final Index.UpdateMode mode, Supplier<UnmanagedIndexSearcher> indexSearcherSupplier) {
        this(new Supplier<IndexWriter>(){

            public IndexWriter get() {
                try {
                    IndexWriterConfiguration.WriterSettings writerSettings = configuration.getWriterSettings(mode);
                    IndexWriterConfig luceneConfig = writerSettings.getWriterConfiguration(configuration.getAnalyzer());
                    LuceneDirectoryUtils luceneDirectoryUtils = (LuceneDirectoryUtils)ComponentAccessor.getComponent(LuceneDirectoryUtils.class);
                    luceneConfig.setIndexDeletionPolicy(luceneDirectoryUtils.getDeletionPolicy(configuration.getDirectory()));
                    return MonitoringIndexWriter.create(configuration.getDirectory(), luceneConfig);
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
        }, indexSearcherSupplier, configuration.getWriterSettings(mode).getFlushPolicy(), configuration.getWriterSettings(mode).getCommitFrequency());
    }

    @Override
    public void addDocuments(@Nonnull Collection<Document> documents) throws IOException {
        for (Document document : documents) {
            this.writer.addDocument((Iterable)Assertions.notNull((String)"document", (Object)document));
        }
    }

    @Override
    public void deleteDocuments(@Nonnull Term identifyingTerm) throws IOException {
        this.writer.deleteDocuments(new Term[]{(Term)Assertions.notNull((String)"identifyingTerm", (Object)identifyingTerm)});
    }

    @Override
    public void updateDocuments(@Nonnull Term identifyingTerm, @Nonnull Collection<Document> documents) throws IOException {
        if (documents.size() == 1) {
            this.writer.updateDocument(identifyingTerm, (Iterable)documents.iterator().next());
        } else {
            this.writer.deleteDocuments(new Term[]{identifyingTerm});
            for (Document document : documents) {
                this.writer.addDocument((Iterable)document);
            }
        }
    }

    @Override
    public void updateDocumentConditionally(@Nonnull Term identifyingTerm, @Nonnull Document document, @Nonnull String optimisticLockField) throws IOException {
        BooleanQuery.Builder updateCondition = new BooleanQuery.Builder();
        updateCondition.add(new BooleanClause((Query)new TermQuery(identifyingTerm), BooleanClause.Occur.MUST));
        updateCondition.add(new BooleanClause(LongPoint.newRangeQuery((String)optimisticLockField, (long)0L, (long)document.getField(optimisticLockField).numericValue().longValue()), BooleanClause.Occur.MUST));
        try (UnmanagedIndexSearcher searcher = (UnmanagedIndexSearcher)this.indexSearcherSupplier.get();){
            TopDocs topDocs = searcher.search((Query)updateCondition.build(), 1);
            if (topDocs.totalHits > 0L) {
                this.writer.updateDocument(identifyingTerm, (Iterable)document);
            }
        }
    }

    @Override
    public void optimize() throws IOException {
    }

    @Override
    public void commit() {
        try {
            this.writer.commit();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            if (DefaultIndexEngine.FlushPolicy.PERIODIC.equals((Object)this.flushPolicy)) {
                this.writer.commit();
            }
            this.writer.close();
        }
        catch (NoSuchFileException noSuchFileException) {
            log.info("Closing index writer with non-existing file. Ignoring: {}", (Object)noSuchFileException.getMessage(), (Object)noSuchFileException);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public DefaultIndexEngine.FlushPolicy getFlushPolicy() {
        return this.flushPolicy;
    }

    @Override
    public long getCommitFrequency() {
        return this.commitFrequency;
    }
}

