/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.index.DelayCloseSearcher;
import com.atlassian.jira.index.DelegateSearcher;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.search.IndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnmanagedIndexSearcher
extends DelegateSearcher
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(UnmanagedIndexSearcher.class);
    private final AtomicBoolean closedOnce;
    private final DelayCloseSearcher closeableSearcher;

    public UnmanagedIndexSearcher(DelayCloseSearcher searcher) {
        super((IndexSearcher)searcher);
        this.closeableSearcher = searcher;
        this.closedOnce = new AtomicBoolean(false);
    }

    DelayCloseSearcher internal() {
        return this.closeableSearcher;
    }

    @Override
    public void close() {
        if (this.closedOnce.compareAndSet(false, true)) {
            this.closeableSearcher.close();
        } else {
            log.warn("Trying to close an {} index searcher twice.", (Object)UnmanagedIndexSearcher.class.getSimpleName(), (Object)new Exception());
        }
    }

    public boolean isClosed() {
        return this.closedOnce.get();
    }
}

