/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringIndexWriter
extends IndexWriter {
    private static final Logger log = LoggerFactory.getLogger(MonitoringIndexWriter.class);
    private final AtomicLong flushCounterSnapshot = new AtomicLong();
    private final AtomicLong flushCounterTotal = new AtomicLong();
    private final Stopwatch lastPrintStats;
    private static final long STATS_PERIOD_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    private static final long WARN_REASONABLE_VALUE_OF_STATS_PERIOD_MILLIS = STATS_PERIOD_MILLIS / 2L;
    private static final String SYSTEM_PROPERTY_NAME_WARN_MIN_FLUSH_INTERVAL_MILLIS = "jira.index.warn.flush.min.interval.millis";
    private static final String KB_URL = "https://confluence.atlassian.com/x/w0VwOQ";

    MonitoringIndexWriter(Directory d, IndexWriterConfig conf, Ticker ticker) throws IOException {
        super(d, conf);
        this.lastPrintStats = Stopwatch.createStarted((Ticker)ticker);
    }

    private static long warnMinFlushIntervalMillis(long defaultValue) {
        try {
            return Long.parseLong(JiraSystemProperties.getInstance().getProperty(SYSTEM_PROPERTY_NAME_WARN_MIN_FLUSH_INTERVAL_MILLIS, defaultValue + ""));
        }
        catch (Exception e) {
            log.error("Error when getting system property value: {}. Using default value: {}", new Object[]{SYSTEM_PROPERTY_NAME_WARN_MIN_FLUSH_INTERVAL_MILLIS, defaultValue, e});
            return defaultValue;
        }
    }

    public static MonitoringIndexWriter create(Directory d, IndexWriterConfig conf) throws IOException {
        return new MonitoringIndexWriter(d, conf, Ticker.systemTicker());
    }

    protected void doAfterFlush() {
        try {
            this.flushCounterSnapshot.incrementAndGet();
            this.flushCounterTotal.incrementAndGet();
            this.printStatsNotToOften();
        }
        catch (Exception e) {
            log.error("Error when monitoring lucene flushes in doAfterFlush(): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void close() throws IOException {
        super.close();
        try {
            Directory directory = this.getDirectory();
            if (directory instanceof RAMDirectory) {
                log.trace("[lucene-stats] Not printing lucene-stats when closing index writer for directory: {}", (Object)directory);
            } else {
                this.printAndResetStats();
            }
        }
        catch (Exception e) {
            log.error("Error when monitoring lucene flushes in close(): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void printStatsNotToOften() {
        if (this.lastPrintStats.elapsed(TimeUnit.MILLISECONDS) > STATS_PERIOD_MILLIS) {
            this.printAndResetStats();
        }
    }

    @Nullable
    private Path getDirectoryPath() {
        Directory directory = this.getDirectory();
        if (directory instanceof FSDirectory) {
            return ((FSDirectory)directory).getDirectory();
        }
        return null;
    }

    private void printAndResetStats() {
        if (this.flushCounterSnapshot.get() > 0L) {
            long periodMillis = this.lastPrintStats.elapsed(TimeUnit.MILLISECONDS);
            long counterSnapshot = this.flushCounterSnapshot.get();
            long counterTotal = this.flushCounterTotal.get();
            long flushIntervalMillis = periodMillis / counterSnapshot;
            log.info("[lucene-stats] flush stats: snapshotCount={}, totalCount={}, periodSec={}, flushIntervalMillis={}, indexDirectory={}, indexWriterId={}, indexDirectoryId={}", new Object[]{counterSnapshot, counterTotal, TimeUnit.MILLISECONDS.toSeconds(periodMillis), flushIntervalMillis, this.getDirectoryPath(), ((Object)((Object)this)).toString(), this.getDirectory()});
            long warnMinFlushIntervalMillis = MonitoringIndexWriter.warnMinFlushIntervalMillis(1000L);
            if (periodMillis > WARN_REASONABLE_VALUE_OF_STATS_PERIOD_MILLIS && flushIntervalMillis < warnMinFlushIntervalMillis) {
                log.warn("Detected frequent flushes (every {} millis) of lucene index which is below warning limit: {}={} millis. This may affect indexing performance. Please visit {} for more information.", new Object[]{flushIntervalMillis, SYSTEM_PROPERTY_NAME_WARN_MIN_FLUSH_INTERVAL_MILLIS, warnMinFlushIntervalMillis, KB_URL});
            }
            this.flushCounterSnapshot.set(0L);
        }
        this.lastPrintStats.reset().start();
    }
}

