/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.parser;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalLabel;
import com.atlassian.jira.imports.project.core.EntityRepresentation;
import com.atlassian.jira.imports.project.core.EntityRepresentationImpl;
import com.atlassian.jira.imports.project.parser.LabelParser;
import com.atlassian.jira.util.dbc.Null;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class LabelParserImpl
implements LabelParser {
    private static final String ID = "id";
    private static final String ISSUE = "issue";
    private static final String LABEL = "label";
    private static final String CUSTOM_FIELD_ID = "fieldid";

    @Override
    public ExternalLabel parse(Map attributes) throws ParseException {
        Null.not("attributes", attributes);
        String idString = (String)attributes.get(ID);
        String issueIdString = (String)attributes.get(ISSUE);
        String labelString = (String)attributes.get(LABEL);
        if (StringUtils.isEmpty((CharSequence)idString)) {
            throw new ParseException("A label must have an id specified.");
        }
        if (StringUtils.isEmpty((CharSequence)issueIdString)) {
            throw new ParseException("A label must have an issue id specified.");
        }
        if (StringUtils.isEmpty((CharSequence)labelString)) {
            throw new ParseException("A label must have a label specified.");
        }
        if (!com.atlassian.jira.issue.label.LabelParser.isValidLabelName((String)labelString)) {
            throw new ParseException("Invalid label '" + labelString + "' specified.");
        }
        String customFieldIdString = (String)attributes.get(CUSTOM_FIELD_ID);
        ExternalLabel label = new ExternalLabel();
        label.setId(idString);
        label.setIssueId(issueIdString);
        label.setCustomFieldId(customFieldIdString);
        label.setLabel(labelString);
        return label;
    }

    @Override
    public EntityRepresentation getEntityRepresentation(ExternalLabel label) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(ID, label.getId());
        attributes.put(ISSUE, label.getIssueId());
        attributes.put(CUSTOM_FIELD_ID, label.getCustomFieldId());
        attributes.put(LABEL, label.getLabel());
        return new EntityRepresentationImpl("Label", attributes);
    }
}

