/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalComment;
import com.atlassian.jira.external.beans.ExternalGroup;
import com.atlassian.jira.external.beans.ExternalWorklog;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.mapper.SimpleProjectImportIdMapper;
import com.atlassian.jira.imports.project.parser.CommentParser;
import com.atlassian.jira.imports.project.parser.CommentParserImpl;
import com.atlassian.jira.imports.project.parser.GroupParser;
import com.atlassian.jira.imports.project.parser.GroupParserImpl;
import com.atlassian.jira.imports.project.parser.WorklogParser;
import com.atlassian.jira.imports.project.parser.WorklogParserImpl;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupMapperHandler
implements ImportOfBizEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(GroupMapperHandler.class);
    private final BackupProject backupProject;
    private final SimpleProjectImportIdMapper groupMapper;
    private GroupParser groupParser;
    private CommentParser commentParser;
    private WorklogParser worklogParser;

    public GroupMapperHandler(BackupProject backupProject, SimpleProjectImportIdMapper groupMapper) {
        this.backupProject = backupProject;
        this.groupMapper = groupMapper;
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        String groupName;
        ExternalWorklog worklog;
        if ("Group".equals(entityName)) {
            ExternalGroup group = this.getGroupParser().parse(attributes);
            this.groupMapper.registerOldValue(group.getName(), group.getName());
        } else if ("Action".equals(entityName)) {
            String groupName2;
            ExternalComment comment = this.getCommentParser().parse(attributes);
            if (comment != null && this.backupProject.containsIssue(comment.getIssueId()) && (groupName2 = comment.getGroupLevel()) != null && groupName2.length() > 0) {
                if (log.isDebugEnabled() && !this.groupMapper.getRequiredOldIds().contains(groupName2)) {
                    log.debug("The group '" + groupName2 + "' is required because it is used in the security of comment (Action) with id = '" + comment.getId() + "'.");
                }
                this.groupMapper.flagValueAsRequired(comment.getGroupLevel());
            }
        } else if ("Worklog".equals(entityName) && this.backupProject.containsIssue((worklog = this.getWorklogParser().parse(attributes)).getIssueId()) && (groupName = worklog.getGroupLevel()) != null && groupName.length() > 0) {
            if (log.isDebugEnabled() && !this.groupMapper.getRequiredOldIds().contains(groupName)) {
                log.debug("The group '" + groupName + "' is required because it is used in the security of Worklog with id = '" + worklog.getId() + "'.");
            }
            this.groupMapper.flagValueAsRequired(worklog.getGroupLevel());
        }
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    GroupParser getGroupParser() {
        if (this.groupParser == null) {
            this.groupParser = new GroupParserImpl();
        }
        return this.groupParser;
    }

    CommentParser getCommentParser() {
        if (this.commentParser == null) {
            this.commentParser = new CommentParserImpl();
        }
        return this.commentParser;
    }

    WorklogParser getWorklogParser() {
        if (this.worklogParser == null) {
            this.worklogParser = new WorklogParserImpl();
        }
        return this.worklogParser;
    }
}

