/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.util.ProjectImportTemporaryFiles;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntity;
import org.ofbiz.core.entity.model.ModelEntity;

public class GenericEntitiesPartitionHandler
implements ImportOfBizEntityHandler {
    private final BackupProject backupProject;
    private final ProjectImportTemporaryFiles projectImportTemporaryFiles;
    private final Map<String, ModelEntity> modelEntityMap;
    private final GenericDelegator delegator;
    private String currentEntity;
    private PrintWriter printWriter;
    private int entityCount = 0;

    public GenericEntitiesPartitionHandler(BackupProject backupProject, ProjectImportTemporaryFiles projectImportTemporaryFiles, List<ModelEntity> modelEntities, DelegatorInterface delegatorInterface) {
        this.backupProject = backupProject;
        this.projectImportTemporaryFiles = projectImportTemporaryFiles;
        this.delegator = GenericDelegator.getGenericDelegator((String)delegatorInterface.getDelegatorName());
        this.modelEntityMap = new HashMap<String, ModelEntity>();
        for (ModelEntity modelEntity : modelEntities) {
            String entityName = modelEntity.getEntityName();
            this.modelEntityMap.put(entityName, modelEntity);
        }
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        ModelEntity modelEntity = this.modelEntityMap.get(entityName);
        if (modelEntity == null) {
            return;
        }
        ++this.entityCount;
        this.writeXmlText(entityName, attributes, modelEntity);
    }

    private void writeXmlText(String entityName, Map<String, String> attributes, ModelEntity modelEntity) throws ParseException {
        if (!entityName.equals(this.currentEntity)) {
            this.endDocument();
        }
        if (this.printWriter == null) {
            try {
                this.currentEntity = entityName;
                this.printWriter = this.projectImportTemporaryFiles.getWriter(entityName);
            }
            catch (IOException e) {
                throw new ParseException(e.getMessage());
            }
        }
        GenericEntity genericEntity = new GenericEntity(this.delegator, modelEntity, attributes);
        genericEntity.writeXmlText(this.printWriter, null);
    }

    public void startDocument() {
    }

    public void endDocument() {
        this.printWriter = null;
    }

    public Map<String, ModelEntity> getRegisteredHandlers() {
        return Collections.unmodifiableMap(this.modelEntityMap);
    }

    public int getEntityCount() {
        return this.entityCount;
    }
}

