/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldOption;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.mapper.CustomFieldOptionMapper;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CustomFieldOptionsMapperHandler
implements ImportOfBizEntityHandler {
    private final CustomFieldOptionMapper customFieldOptionMapper;
    public static final String CUSTOM_FIELD_OPTION_ENTITY_NAME = "CustomFieldOption";
    private static final String ID = "id";
    private static final String CUSTOMFIELD = "customfield";
    private static final String CUSTOMFIELDCONFIG = "customfieldconfig";
    private static final String PARENTOPTIONID = "parentoptionid";
    private static final String VALUE = "value";

    public CustomFieldOptionsMapperHandler(CustomFieldOptionMapper customFieldOptionMapper) {
        this.customFieldOptionMapper = customFieldOptionMapper;
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        if (CUSTOM_FIELD_OPTION_ENTITY_NAME.equals(entityName)) {
            String id = attributes.get(ID);
            String customFieldId = attributes.get(CUSTOMFIELD);
            String fieldConfigId = attributes.get(CUSTOMFIELDCONFIG);
            String parentId = attributes.get(PARENTOPTIONID);
            String value = attributes.get(VALUE);
            if (StringUtils.isBlank((CharSequence)id)) {
                throw new ParseException("Encountered an entity of type 'CustomFieldOption' with a missing ID.");
            }
            if (StringUtils.isBlank((CharSequence)customFieldId)) {
                throw new ParseException("The customfield of CustomFieldOption '" + id + "' is missing.");
            }
            if (StringUtils.isBlank((CharSequence)fieldConfigId)) {
                throw new ParseException("The customfieldconfig of CustomFieldOption '" + id + "' is missing.");
            }
            ExternalCustomFieldOption externalCustomFieldOption = new ExternalCustomFieldOption(id, customFieldId, fieldConfigId, parentId, value);
            this.customFieldOptionMapper.registerOldValue(externalCustomFieldOption);
        }
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomFieldOptionsMapperHandler that = (CustomFieldOptionsMapperHandler)o;
        return !(this.customFieldOptionMapper != null ? !this.customFieldOptionMapper.equals(that.customFieldOptionMapper) : that.customFieldOptionMapper != null);
    }

    public int hashCode() {
        return this.customFieldOptionMapper != null ? this.customFieldOptionMapper.hashCode() : 0;
    }
}

