/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalNodeAssociation;
import com.atlassian.jira.imports.project.ProjectImportPersister;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.handler.AbstractPersisterHandler;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.parser.NodeAssociationParser;
import com.atlassian.jira.imports.project.parser.NodeAssociationParserImpl;
import com.atlassian.jira.imports.project.transformer.ComponentTransformer;
import com.atlassian.jira.imports.project.transformer.ComponentTransformerImpl;
import java.util.Map;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentPersisterHandler
extends AbstractPersisterHandler
implements ImportOfBizEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(ComponentPersisterHandler.class);
    private final ProjectImportPersister projectImportPersister;
    private final ProjectImportMapper projectImportMapper;
    private final ProjectImportResults projectImportResults;
    private final BackupSystemInformation backupSystemInformation;
    private NodeAssociationParser nodeAssocationParser;
    private ComponentTransformer componentTransformer;

    public ComponentPersisterHandler(ProjectImportPersister projectImportPersister, ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        super(executor, projectImportResults);
        this.projectImportPersister = projectImportPersister;
        this.projectImportMapper = projectImportMapper;
        this.projectImportResults = projectImportResults;
        this.backupSystemInformation = backupSystemInformation;
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException, AbortImportException {
        ExternalNodeAssociation transformedExternalComponent;
        ExternalNodeAssociation externalComponent;
        if ("NodeAssociation".equals(entityName) && (externalComponent = this.getNodeAssociationParser().parse(attributes)) != null && "IssueComponent".equals(externalComponent.getAssociationType()) && (transformedExternalComponent = this.getComponentTransformer().transform(this.projectImportMapper, externalComponent)) != null) {
            if (transformedExternalComponent.getSourceNodeId() != null) {
                this.execute(() -> {
                    if (!this.projectImportPersister.createAssociation(transformedExternalComponent)) {
                        String issueKey = this.backupSystemInformation.getIssueKeyForId(externalComponent.getSourceNodeId());
                        String compName = this.projectImportMapper.getComponentMapper().getDisplayName(externalComponent.getSinkNodeId());
                        this.projectImportResults.addError(this.projectImportResults.getI18n().getText("admin.errors.project.import.component.error", compName, issueKey));
                    }
                });
            } else {
                String issueKey = this.backupSystemInformation.getIssueKeyForId(externalComponent.getSourceNodeId());
                String compName = this.projectImportMapper.getComponentMapper().getDisplayName(externalComponent.getSinkNodeId());
                log.warn("Not saving component '" + compName + "' it appears that the issue '" + issueKey + "' was not created as part of the import.");
            }
        }
    }

    ComponentTransformer getComponentTransformer() {
        if (this.componentTransformer == null) {
            this.componentTransformer = new ComponentTransformerImpl();
        }
        return this.componentTransformer;
    }

    NodeAssociationParser getNodeAssociationParser() {
        if (this.nodeAssocationParser == null) {
            this.nodeAssocationParser = new NodeAssociationParserImpl();
        }
        return this.nodeAssocationParser;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }
}

