/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalAttachment;
import com.atlassian.jira.imports.project.ProjectImportPersister;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.ProjectImportOptions;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.handler.AbstractPersisterHandler;
import com.atlassian.jira.imports.project.handler.AttachmentFileValidatorHandler;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.parser.AttachmentParser;
import com.atlassian.jira.imports.project.parser.AttachmentParserImpl;
import com.atlassian.jira.imports.project.transformer.AttachmentTransformer;
import com.atlassian.jira.imports.project.transformer.AttachmentTransformerImpl;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentStore;
import java.io.File;
import java.util.Map;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentPersisterHandler
extends AbstractPersisterHandler
implements ImportOfBizEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(AttachmentPersisterHandler.class);
    private final ProjectImportPersister projectImportPersister;
    private final ProjectImportOptions projectImportOptions;
    private final ProjectImportMapper projectImportMapper;
    private final BackupProject backupProject;
    private final BackupSystemInformation backupSystemInformation;
    private final ProjectImportResults projectImportResults;
    private final AttachmentParser attachmentParser;
    private final AttachmentTransformer attachmentTransformer;

    public AttachmentPersisterHandler(ProjectImportPersister projectImportPersister, ProjectImportOptions projectImportOptions, ProjectImportMapper projectImportMapper, BackupProject backupProject, BackupSystemInformation backupSystemInformation, ProjectImportResults projectImportResults, Executor executor, AttachmentStore attachmentStore) {
        this(projectImportPersister, projectImportOptions, projectImportMapper, backupProject, backupSystemInformation, projectImportResults, executor, new AttachmentParserImpl(attachmentStore, projectImportOptions.getAttachmentPath()), new AttachmentTransformerImpl());
    }

    protected AttachmentPersisterHandler(ProjectImportPersister projectImportPersister, ProjectImportOptions projectImportOptions, ProjectImportMapper projectImportMapper, BackupProject backupProject, BackupSystemInformation backupSystemInformation, ProjectImportResults projectImportResults, Executor executor, AttachmentParser attachmentParser, AttachmentTransformer attachmentTransformer) {
        super(executor, projectImportResults);
        this.projectImportPersister = projectImportPersister;
        this.projectImportOptions = projectImportOptions;
        this.projectImportMapper = projectImportMapper;
        this.backupProject = backupProject;
        this.backupSystemInformation = backupSystemInformation;
        this.projectImportResults = projectImportResults;
        this.attachmentParser = attachmentParser;
        this.attachmentTransformer = attachmentTransformer;
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException, AbortImportException {
        if (AttachmentFileValidatorHandler.canProcessEntity(entityName, this.projectImportOptions)) {
            final ExternalAttachment externalAttachment = this.attachmentParser.parse(attributes);
            if (externalAttachment.getIssueId() != null) {
                final String issueKey = this.backupSystemInformation.getIssueKeyForId(externalAttachment.getIssueId());
                File attachedFile = this.attachmentParser.getAttachmentFile(externalAttachment, this.backupProject.getProject(), issueKey);
                externalAttachment.setAttachedFile(attachedFile);
                if (attachedFile.exists()) {
                    final ExternalAttachment transformedAttachment = this.attachmentTransformer.transform(this.projectImportMapper, externalAttachment);
                    this.execute(new Runnable(){

                        @Override
                        public void run() {
                            Attachment createdAttachment = AttachmentPersisterHandler.this.projectImportPersister.createAttachment(transformedAttachment);
                            if (createdAttachment == null) {
                                AttachmentPersisterHandler.this.projectImportResults.addError(AttachmentPersisterHandler.this.projectImportResults.getI18n().getText("admin.errors.project.import.attachment.error", externalAttachment.getFileName(), issueKey));
                            } else {
                                AttachmentPersisterHandler.this.projectImportResults.incrementAttachmentsCreatedCount();
                            }
                        }
                    });
                } else {
                    log.warn("Not saving attachment '" + externalAttachment.getFileName() + "' for issue '" + issueKey + "', the file does not exist in the provided attachment directory.");
                }
            } else {
                log.warn("Not saving attachment '" + externalAttachment.getFileName() + "' it appears that the issue was not created as part of the import.");
            }
        }
    }

    public void startDocument() {
    }

    public void endDocument() {
    }
}

