/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.web;

import com.atlassian.jira.health.web.JohnsonEventSerializer;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventType;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
class LegacyJohnsonEventSerializer
implements JohnsonEventSerializer {
    private static final Logger log = LoggerFactory.getLogger(LegacyJohnsonEventSerializer.class);
    private final String contextPath;

    LegacyJohnsonEventSerializer(String requestContextPath) {
        this.contextPath = requestContextPath;
    }

    @Override
    @Nonnull
    public JSONObject toJSON(Event johnsonEvent) {
        JSONObject eventJSON = new JSONObject();
        try {
            eventJSON.put("description", (Object)johnsonEvent.getDesc()).put("date", (Object)johnsonEvent.getDate());
            eventJSON.put("level", (Object)johnsonEvent.getLevel().getLevel());
            eventJSON.put("dismissible", Boolean.TRUE.equals(johnsonEvent.getAttribute((Object)"dismissible")));
            eventJSON.put("exception", (Object)johnsonEvent.getException()).put("old", true);
            this.getProgress(johnsonEvent).ifPresent(progress -> {
                try {
                    eventJSON.put("progress", progress);
                }
                catch (JSONException e) {
                    log.warn("Failed to add progress marker", (Throwable)e);
                }
            });
            this.getAdditionalMarkup(johnsonEvent, this.contextPath).ifPresent(additionalMarkup -> {
                try {
                    eventJSON.put("additionalMarkup", additionalMarkup);
                }
                catch (JSONException e) {
                    log.warn("Failed to add markup", (Throwable)e);
                }
            });
        }
        catch (JSONException e) {
            throw new IllegalStateException("Failed to serialize: " + johnsonEvent, e);
        }
        return eventJSON;
    }

    private OptionalInt getProgress(Event event) throws JSONException {
        if (event.hasProgress()) {
            return OptionalInt.of(event.getProgress());
        }
        return OptionalInt.empty();
    }

    private Optional<String> getAdditionalMarkup(Event event, String contextPath) throws JSONException {
        if (JohnsonEventType.LICENSE_TOO_OLD.eventType().equals((Object)event.getKey())) {
            String additionalMarkup = "<br/>" + "<a href=\"" + contextPath + "/secure/ConfirmNewInstallationWithOldLicense!default.jspa\">" + "{{system.error.edit.license.or.evaluate}}" + "</a>";
            return Optional.of(additionalMarkup);
        }
        if (JohnsonEventType.CLUSTERING_UNLICENSED.eventType().equals((Object)event.getKey()) || JohnsonEventType.SUBSCRIPTION_EXPIRED.eventType().equals((Object)event.getKey())) {
            String additionalMarkup = "<br/>" + "<a href=\"" + contextPath + "/secure/ConfirmNewInstallationWithOldLicense!default.jspa\">" + "{{system.error.edit.license}}" + "</a>";
            return Optional.of(additionalMarkup);
        }
        if (EventType.get((String)"index-lock-already-exists").equals((Object)event.getKey())) {
            Object lockFiles = event.getAttribute((Object)"lockfiles");
            if (lockFiles == null) {
                return Optional.empty();
            }
            String additionalMarkup = "<p>" + "{{system.error.unexpected.index.lock.found.desc1}}" + "<br/>" + "<br/>" + lockFiles + "<br/>" + "<br/>" + "{{system.error.unexpected.index.lock.found.desc2}}" + "</p>" + "<p>" + "{{system.error.unexpected.index.lock.found.desc3}}" + "</p>";
            return Optional.of(additionalMarkup);
        }
        return Optional.empty();
    }
}

