/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.web;

import com.atlassian.jira.health.web.InteractiveJohnsonEventSerializer;
import com.atlassian.jira.health.web.JohnsonEventSerializer;
import com.atlassian.jira.health.web.LegacyJohnsonEventSerializer;
import com.atlassian.johnson.event.Event;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class JohnsonEventSerializerFactory {
    private final InteractiveJohnsonEventSerializer betterJohnsonEventSerializer = new InteractiveJohnsonEventSerializer();
    private final LegacyJohnsonEventSerializer legacyJohnsonEventSerializer;

    public JohnsonEventSerializerFactory(String contextPath) {
        this.legacyJohnsonEventSerializer = new LegacyJohnsonEventSerializer(contextPath);
    }

    @Nonnull
    public JohnsonEventSerializer forEvent(Event event) {
        if (this.isEventForBetterUI(event)) {
            return this.betterJohnsonEventSerializer;
        }
        return this.legacyJohnsonEventSerializer;
    }

    private boolean isEventForBetterUI(Event event) {
        return "CPU-59".equals(event.getAttribute((Object)"uiVersion"));
    }
}

