/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks.database;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.database.DatabaseVendor;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.health.checks.database.SupportedDatabases;
import com.atlassian.jira.health.checks.database.Version;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevels;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class SupportedDatabaseVersionHealthCheck
extends HealthCheckTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(SupportedDatabaseVersionHealthCheck.class);
    private static final String CAUSE = "supported-database-version-check";
    private static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/eh8GO");
    private static final EnumSet databaseVendorsThisHealthCheckHasBeenTestedWith = EnumSet.of(DatabaseVendor.MY_SQL, DatabaseVendor.POSTGRES, DatabaseVendor.SQL_SERVER);

    public SupportedDatabaseVersionHealthCheck(HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
    }

    private boolean isSupported(@Nonnull DatabaseVendor vendor, @Nullable String databaseVersion) {
        Version version;
        if (databaseVersion == null) {
            return false;
        }
        List<String> versionList = SupportedDatabases.getDatabaseVersions().get(vendor);
        if (vendor.equals((Object)DatabaseVendor.SQL_SERVER)) {
            return versionList.contains(DatabaseVendor.getSQLServerVersionIfExists((String)databaseVersion));
        }
        try {
            version = Version.of(databaseVersion);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("SupportedDatabaseVersionHealthCheck is unable to run because the version number retrieved by the database is isn't a version number we expected to get (major.minor.micro)This probably means the database is not supported");
            return false;
        }
        return versionList.contains(version.getMajorAndMinor());
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return Collections.singleton(LifecyclePhase.POST_DATABASE_ACTIVATED);
    }

    @Override
    protected List<HealthCheckResult> doPerform() {
        DatabaseAccessor databaseAccessor = (DatabaseAccessor)ComponentAccessor.getComponent(DatabaseAccessor.class);
        return this.getHealthCheckResults(databaseAccessor);
    }

    private List<HealthCheckResult> getHealthCheckResults(DatabaseAccessor databaseAccessor) {
        String databaseVersion;
        DatabaseVendor vendor = databaseAccessor.getDatabaseVendor();
        if (databaseVendorsThisHealthCheckHasBeenTestedWith.contains(vendor) && !this.isSupported(vendor, databaseVersion = databaseAccessor.getVersion())) {
            HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter().append(HealthCheckMessageFormatter.string(vendor.getHumanReadableName())).append(HealthCheckMessageFormatter.string(" ")).append(HealthCheckMessageFormatter.string(vendor.getHumanReadableVersion(databaseVersion))).append(HealthCheckMessageFormatter.string(" is not supported. You should migrate to a supported database version.")).addLineBreak().append(HealthCheckMessageFormatter.string("Supported versions are: ")).append(HealthCheckMessageFormatter.string(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)SupportedDatabases.getDatabaseVersions().get(vendor))));
            Event event = new Event(JohnsonEventType.DATABASE.eventType(), "Supported database", messageFormatter.toHtml(), EventLevels.warning());
            event.addAttribute((Object)"dismissible", (Object)true);
            return HealthCheckResult.fail(this, event, KB_URL, CAUSE, messageFormatter.toText());
        }
        return Collections.emptyList();
    }
}

