/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks.database;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevels;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicSchemaHealthCheck
extends HealthCheckTemplate {
    private static final Logger log = LoggerFactory.getLogger(PublicSchemaHealthCheck.class);
    private static final Set<String> ALLOWED_FIELD_TYPE_NAMES = ImmutableSet.of((Object)"h2", (Object)"hsql");
    private static final String KEY_PUBLIC_SCHEMA_CONFIG_DISABLED = "atlassian.jira.dbcheck.publicschemaconfig.disabled";
    private static final String SCHEMA_PUBLIC = "PUBLIC";
    private static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/UwSNN");

    public PublicSchemaHealthCheck(HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.POST_DATABASE_ACTIVATED));
    }

    @Override
    protected List<HealthCheckResult> doPerform() {
        DatabaseConfigurationManager databaseConfigurationManager = (DatabaseConfigurationManager)ComponentAccessor.getComponent(DatabaseConfigurationManager.class);
        return this.performCheck(databaseConfigurationManager.getDatabaseConfiguration().getDatasourceInfo());
    }

    public List<HealthCheckResult> performCheck(DatasourceInfo datasourceInfo) {
        if (Boolean.valueOf(JiraSystemProperties.getInstance().getProperty(KEY_PUBLIC_SCHEMA_CONFIG_DISABLED)).booleanValue()) {
            log.debug("Skipping public schema config check");
            return Collections.emptyList();
        }
        String fieldTypeName = datasourceInfo.getFieldTypeName();
        String schemaName = datasourceInfo.getSchemaName();
        if (SCHEMA_PUBLIC.equals(schemaName) && !ALLOWED_FIELD_TYPE_NAMES.contains(fieldTypeName)) {
            return this.createHealthCheckResult();
        }
        return Collections.emptyList();
    }

    private List<HealthCheckResult> createHealthCheckResult() {
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter();
        messageFormatter.append(HealthCheckMessageFormatter.string("Your dbconfig.xml file contains the upper case schema-name \"PUBLIC\", which only works for a field-type-name of \"h2\" or \"hsql\". You need to change this to lower case \"public\" to start JIRA.").addLineBreak(), HealthCheckMessageFormatter.string("See our documentation for more information on editing your dbconfig.xml file."));
        return HealthCheckResult.fail(this, new Event(JohnsonEventType.DATABASE.eventType(), "We've detected that your JIRA instance is using an illegal schema name", messageFormatter.toHtml(), EventLevels.fatal()), KB_URL, "illegal-schema-name", messageFormatter.toText());
    }
}

