/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks.database;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevels;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresSchemaHealthCheck
extends HealthCheckTemplate {
    private static final Logger log = LoggerFactory.getLogger(PostgresSchemaHealthCheck.class);
    private static final String FIELD_TYPE_NAME_POSTGRES72 = "postgres72";
    private static final String FIELD_TYPE_NAME_POSTGRES = "postgres";
    private static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/UwSNN");

    public PostgresSchemaHealthCheck(HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.POST_DATABASE_ACTIVATED));
    }

    @Override
    protected List<HealthCheckResult> doPerform() {
        DatabaseConfigurationManager databaseConfigurationManager = (DatabaseConfigurationManager)ComponentAccessor.getComponent(DatabaseConfigurationManager.class);
        return this.performCheck(databaseConfigurationManager.getDatabaseConfiguration().getDatasourceInfo());
    }

    public List<HealthCheckResult> performCheck(DatasourceInfo dsi) {
        if (dsi != null) {
            String schemaName;
            String fieldTypeName = dsi.getFieldTypeName();
            if ((FIELD_TYPE_NAME_POSTGRES.equals(fieldTypeName) || FIELD_TYPE_NAME_POSTGRES72.equals(fieldTypeName)) && !this.isSchemaNameValid(schemaName = dsi.getSchemaName())) {
                return this.createHealthCheckResult();
            }
        } else {
            log.error("Could not read the datasource info!");
        }
        return Collections.emptyList();
    }

    private boolean isSchemaNameValid(String schemaName) {
        if (schemaName == null) {
            return false;
        }
        String lowerCaseSchemaName = schemaName.toLowerCase(Locale.ENGLISH);
        return lowerCaseSchemaName.equals(schemaName);
    }

    private List<HealthCheckResult> createHealthCheckResult() {
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter();
        messageFormatter.append(HealthCheckMessageFormatter.string("The 'schema-name' property in your "), HealthCheckMessageFormatter.tag("code", HealthCheckMessageFormatter.string("dbconfig.xml")), HealthCheckMessageFormatter.string(" file contains upper case letters. JIRA only supports lower case schema names in Postgres databases.").addLineBreak(), HealthCheckMessageFormatter.string("See our documentation for more information on editing your dbconfig.xml file."));
        Event event = new Event(JohnsonEventType.DATABASE.eventType(), "We've detected that your JIRA instance is using an illegal schema name", messageFormatter.toHtml(), EventLevels.warning());
        event.addAttribute((Object)"dismissible", (Object)true);
        return HealthCheckResult.fail(this, event, KB_URL, "illegal-schema-name", messageFormatter.toText());
    }
}

