/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventLevel;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.jira.util.tomcat.TomcatConfigReaderHelper;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.johnson.event.Event;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class TomcatConfigurationHealthCheck
extends HealthCheckTemplate {
    private static final Logger LOG = LoggerFactory.getLogger(TomcatConfigurationHealthCheck.class);
    private static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/J9ggOQ");
    private static final String KEY_RELAXED_CHARACTERS_HEALTH_CHECK_DISABLED = "atlassian.jira.setupcheck.relaxedcharacters.disabled";
    private static final List<String> REQUIRED_RELAXED_PATH_CHARS = ImmutableList.of((Object)"[", (Object)"]", (Object)"|");
    private static final List<String> REQUIRED_RELAXED_QUERY_CHARS = ImmutableList.of((Object)"[", (Object)"]", (Object)"|", (Object)"{", (Object)"}", (Object)"^", (Object)"\\", (Object)"`", (Object)"\"", (Object)"<", (Object)">");
    public static final String RELAXED_PATH_CHARS_ATTRIBUTE = "relaxedPathChars";
    public static final String RELAXED_QUERY_CHARS_ATTRIBUTE = "relaxedQueryChars";
    private static final String FAIL_CAUSE_TEXT = "server-misconfiguration";
    private static final String FAIL_EVENT_DESCRIPTION = "Tomcat is misconfigured";
    private static final String HEALTH_CHECK_FAILED = "The server.xml file is missing parameters needed by Jira to handle requests that contain special characters.";
    private static final String HEALTH_CHECK_UNEXPECTED_ERROR = "Jira couldn't complete the health check on the Tomcat configuration in your server.xml file. For more info, see {0}";
    private static final String HEALTH_CHECK_SKIPPED = "Skipping relaxed characters for Tomcat health check";
    private static final int MINIMAL_RELAXABLE_TOMCAT85_VERSION = 32;
    private static final int MINIMAL_RELAXABLE_TOMCAT90_VERSION = 12;
    Pattern TOMCAT_85_PATTERN = Pattern.compile("Apache Tomcat/8.5.([0-9]+)");
    Pattern TOMCAT_90_PATTERN = Pattern.compile("Apache Tomcat/9.0.([0-9]+)");
    private static final String INCORRECT_TOMCAT_VERSION = "Server {0} is not compatible with Tomcat 8.5 nor 9.0";
    private static final String NOT_APPLICABLE_FOR_THIS_TOMCAT = "Server {0} does not need characters relaxed";
    private static final String NULL_SERVLET_CONTEXT = "ServletContext is NULL, it should only happen in testing environment.";

    public TomcatConfigurationHealthCheck(HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.POST_DATABASE_ACTIVATED));
    }

    @Override
    @Nonnull
    protected List<HealthCheckResult> doPerform() {
        if (Boolean.valueOf(JiraSystemProperties.getInstance().getProperty(KEY_RELAXED_CHARACTERS_HEALTH_CHECK_DISABLED)).booleanValue()) {
            LOG.info(HEALTH_CHECK_SKIPPED);
            return Collections.emptyList();
        }
        if (!this.isThisTomcatHealthCheckable()) {
            return Collections.emptyList();
        }
        TomcatConfigReaderHelper tomcatConfigReaderHelper = this.getTomcatConfigReaderHelper();
        try {
            List<Object> relaxedPathCharsValues = tomcatConfigReaderHelper.getAttributeFromAllHttpConnectors(RELAXED_PATH_CHARS_ATTRIBUTE);
            List<Object> relaxedQueryCharsValues = tomcatConfigReaderHelper.getAttributeFromAllHttpConnectors(RELAXED_QUERY_CHARS_ATTRIBUTE);
            if (!this.requiredRelaxedCharsAreConfigured(relaxedPathCharsValues, REQUIRED_RELAXED_PATH_CHARS) || !this.requiredRelaxedCharsAreConfigured(relaxedQueryCharsValues, REQUIRED_RELAXED_QUERY_CHARS)) {
                LOG.error("\nRequired path chars: " + String.join((CharSequence)" ", REQUIRED_RELAXED_PATH_CHARS) + "\nConfigured path chars: " + relaxedPathCharsValues.stream().map(o -> (String)o).collect(Collectors.joining(" ")) + "\nRequired query chars: " + String.join((CharSequence)" ", REQUIRED_RELAXED_QUERY_CHARS) + "\nConfigured query chars: " + relaxedQueryCharsValues.stream().map(o -> (String)o).collect(Collectors.joining(" ")) + "\n");
                return this.failCauseMisconfiguration();
            }
        }
        catch (RuntimeException re) {
            LOG.error(MessageFormat.format(HEALTH_CHECK_UNEXPECTED_ERROR, KB_URL), (Throwable)re);
        }
        return Collections.emptyList();
    }

    private boolean isThisTomcatHealthCheckable() {
        if (ServletContextProvider.getServletContext() != null) {
            ServletContext context = ServletContextProvider.getServletContext();
            String serverInfo = context.getServerInfo();
            Matcher tomcat85Matcher = this.TOMCAT_85_PATTERN.matcher(serverInfo);
            Matcher tomcat90Matcher = this.TOMCAT_90_PATTERN.matcher(serverInfo);
            if (tomcat85Matcher.find()) {
                return this.fitsVersion(tomcat85Matcher, 32, serverInfo);
            }
            if (tomcat90Matcher.find()) {
                return this.fitsVersion(tomcat90Matcher, 12, serverInfo);
            }
            LOG.error(MessageFormat.format(INCORRECT_TOMCAT_VERSION, serverInfo));
            return false;
        }
        LOG.warn(NULL_SERVLET_CONTEXT);
        return false;
    }

    private boolean fitsVersion(Matcher tomcatMatcher, int minimalVersion, String serverInfo) {
        int bugfixVersion = Integer.parseInt(tomcatMatcher.group(1));
        if (bugfixVersion < minimalVersion) {
            LOG.debug(MessageFormat.format(NOT_APPLICABLE_FOR_THIS_TOMCAT, serverInfo));
            return false;
        }
        return true;
    }

    private List<HealthCheckResult> failCauseMisconfiguration() {
        HealthCheckMessageFormatter errorMessage = new HealthCheckMessageFormatter().append(HealthCheckMessageFormatter.string(HEALTH_CHECK_FAILED)).addLineBreak();
        Event event = new Event(JohnsonEventType.SETUP.eventType(), FAIL_EVENT_DESCRIPTION, errorMessage.toHtml(), JohnsonEventLevel.ERROR.eventLevel());
        return this.healthCheckResult(event, errorMessage);
    }

    private TomcatConfigReaderHelper getTomcatConfigReaderHelper() {
        return (TomcatConfigReaderHelper)ComponentAccessor.getComponent(TomcatConfigReaderHelper.class);
    }

    private boolean requiredRelaxedCharsAreConfigured(@Nonnull List<Object> valuesFromAllConnectors, List<String> requiredRelaxedChars) {
        return !valuesFromAllConnectors.contains(null) && valuesFromAllConnectors.stream().map(String::valueOf).allMatch(s -> requiredRelaxedChars.stream().allMatch(s::contains));
    }

    private List<HealthCheckResult> healthCheckResult(Event event, HealthCheckMessageFormatter errorMessage) {
        return HealthCheckResult.fail(this, event, KB_URL, FAIL_CAUSE_TEXT, errorMessage.toText());
    }
}

