/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.analytics;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.health.analytics.HealthCheckAnalyticsEvent;
import com.atlassian.jira.health.analytics.HealthCheckAnalyticsEventFactory;
import com.atlassian.jira.health.analytics.HealthCheckAnalyticsSender;
import com.atlassian.jira.health.analytics.HealthCheckJohnsonEvents;
import com.atlassian.jira.health.analytics.KnowledgeBaseArticleClickedEvent;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.johnson.event.Event;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EventPublishingHealthCheckAnalyticsSender
implements HealthCheckAnalyticsSender {
    private final EventPublisher eventPublisher;
    private final HealthCheckAnalyticsEventFactory analyticsEventFactory;
    private final JohnsonProvider johnsonProvider;

    public EventPublishingHealthCheckAnalyticsSender(HealthCheckAnalyticsEventFactory analyticsEventFactory, EventPublisher eventPublisher, JohnsonProvider johnsonProvider) {
        this.analyticsEventFactory = Objects.requireNonNull(analyticsEventFactory);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.johnsonProvider = Objects.requireNonNull(johnsonProvider);
    }

    @Override
    public void sendHealthCheckResult(Event johnsonEvent) {
        HealthCheckAnalyticsEvent analyticsEvent = this.analyticsEventFactory.forHealthCheckResult(johnsonEvent);
        this.eventPublisher.publish((Object)analyticsEvent);
    }

    @Override
    public void sendHelpLinkClicked(String eventId) {
        HealthCheckJohnsonEvents.findEventById(this.johnsonProvider, eventId).ifPresent(event -> {
            HealthCheckAnalyticsEvent analyticsEvent = this.analyticsEventFactory.forJohnsonHelpLinkClicked((Event)event);
            this.eventPublisher.publish((Object)analyticsEvent);
        });
    }

    @Override
    public void sendHelpLinkClickedForEventHiddenPage() {
        this.eventPublisher.publish((Object)new KnowledgeBaseArticleClickedEvent());
    }
}

