/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.operation;

import com.atlassian.jira.event.operation.SpanningOperation;
import com.atlassian.jira.event.operation.SpanningOperationHolder;
import com.atlassian.jira.event.operation.SpanningOperationRunner;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class SpanningOperationRunnerImpl
implements SpanningOperationRunner {
    private final SpanningOperationHolder spanningOperationHolder;

    public SpanningOperationRunnerImpl(SpanningOperationHolder spanningOperationHolder) {
        this.spanningOperationHolder = spanningOperationHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(SpanningOperation spanningOperation, Supplier<T> supplier) {
        this.spanningOperationHolder.push(spanningOperation);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.spanningOperationHolder.pop();
        }
    }

    public void execute(SpanningOperation spanningOperation, Runnable runnable) {
        this.spanningOperationHolder.push(spanningOperation);
        try {
            runnable.run();
        }
        finally {
            this.spanningOperationHolder.pop();
        }
    }

    public <T> T executeCallable(@Nonnull SpanningOperation spanningOperation, @Nonnull Callable<T> callable) {
        this.spanningOperationHolder.push(spanningOperation);
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.spanningOperationHolder.pop();
        }
    }
}

