/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners.reindex;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.action.admin.plugins.PluginReindexHelper;
import com.atlassian.jira.web.action.admin.plugins.PluginReindexHelperImpl;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;

@EventComponent
public class ReindexMessageListener {
    private final PluginReindexHelper pluginReindexHelper;
    private final JiraAuthenticationContext authenticationContext;
    private final ReindexMessageManager reindexMessageManager;
    private final PluginAccessor pluginAccessor;

    public ReindexMessageListener(JiraAuthenticationContext authenticationContext, PluginAccessor pluginAccessor, ReindexMessageManager reindexMessageManager) {
        this.pluginAccessor = pluginAccessor;
        this.reindexMessageManager = reindexMessageManager;
        this.pluginReindexHelper = new PluginReindexHelperImpl(this.pluginAccessor);
        this.authenticationContext = authenticationContext;
    }

    @EventListener
    @ClusterSafe(value="Events are only processed locally")
    public synchronized void pluginModuleEnabled(PluginModuleEnabledEvent pmEnabledEvent) {
        if (this.pluginReindexHelper.doesEnablingPluginModuleRequireMessage(pmEnabledEvent.getModule().getCompleteKey())) {
            this.reindexMessageManager.pushMessage(this.authenticationContext.getUser(), "admin.notifications.task.plugins");
        }
    }
}

